package com.ximai.generator;

import com.ximai.generator.domain.GenTable;
import com.ximai.generator.domain.GenTableColumn;
import com.ximai.generator.service.GenTableServiceImpl;

import java.util.ArrayList;
import java.util.List;

public class BuildUtil {
    public static void main(String[] args) {
        GenTableServiceImpl genTableService = new GenTableServiceImpl();
        GenTable genTable = new GenTable();
        List<GenTableColumn> columns = new ArrayList<>();
        columns.add(new GenTableColumn(){{
            setColumnName("process_name");
            setColumnComment("工序名称");
            setColumnId(1l);
            setJavaType("String");
            setJavaField("processName");
            setIsPk("0");
            setIsInsert("1");
            setIsEdit("1");
            setIsList("1");
            setIsQuery("1");
            setSort(1);
        }});
        columns.add(new GenTableColumn(){{
            setColumnName("process_code");
            setColumnComment("工序编码");
            setColumnId(2l);
            setJavaType("String");
            setJavaField("processCode");
            setIsPk("0");
            setIsInsert("1");
            setIsEdit("1");
            setIsList("1");
            setIsQuery("1");
            setQueryType("EQ");
            setSort(2);
        }});
        columns.add(new GenTableColumn(){{
            setColumnName("process_id");
            setColumnComment("工序ID");
            setColumnId(3l);
            setJavaType("Long");
            setJavaField("processId");
            setIsPk("0");
            setIsInsert("1");
            setIsEdit("1");
            setIsList("1");
            setIsQuery("1");
            setQueryType("EQ");
            setSort(3);
        }});
        columns.add(new GenTableColumn(){{
            setColumnName("id");
            setColumnComment("ID");
            setColumnId(4l);
            setJavaType("Long");
            setJavaField("id");
            setIsPk("1");
            setIsInsert("1");
            setIsEdit("0");
            setIsList("0");
            setIsQuery("1");
            setQueryType("NE");
            setSort(4);
        }});
        columns.add(new GenTableColumn(){{
            setColumnName("start_time");
            setColumnComment("开始生产时间");
            setColumnId(5l);
            setJavaType("Date");
            setJavaField("startTime");
            setIsPk("1");
            setIsInsert("1");
            setIsEdit("1");
            setIsList("1");
            setIsQuery("1");
            setQueryType("GTE");
            setSort(5);
        }});
        columns.add(new GenTableColumn(){{
            setColumnName("quantity_produced");
            setColumnComment("已生产数量");
            setColumnId(6l);
            setJavaType("BigDecimal");
            setJavaField("quantityProduced");
            setIsPk("1");
            setIsInsert("1");
            setIsEdit("1");
            setIsList("1");
            setIsQuery("1");
            setQueryType("LIKE");
            setSort(6);
        }});
        columns.add(new GenTableColumn(){{
            setColumnName("is_formal");
            setColumnComment("是否正式产品");
            setColumnId(8l);
            setJavaType("Integer");
            setJavaField("isFormal");
            setIsPk("1");
            setIsInsert("1");
            setIsEdit("1");
            setIsList("1");
            setIsQuery("0");
            setSort(7);
        }});
        columns.add(new GenTableColumn(){{
            setColumnName("create_by");
            setColumnComment("创建人");
            setColumnId(8l);
            setJavaType("String");
            setJavaField("createBy");
            setIsPk("0");
            setIsInsert("1");
            setIsEdit("0");
            setIsList("1");
            setIsQuery("0");
            setSort(8);
        }});
        columns.add(new GenTableColumn(){{
            setColumnName("create_time");
            setColumnComment("创建时间");
            setColumnId(9l);
            setJavaType("Date");
            setJavaField("createTime");
            setIsPk("0");
            setIsInsert("1");
            setIsEdit("0");
            setIsList("1");
            setIsQuery("0");
            setSort(9);
        }});
        genTable.setColumns(columns);
        genTable.setTableName("pro_bom");
        genTable.setTableComment("BOM表");
        genTable.setClassName("ProBom1");
        genTable.setTplCategory("crud");
        genTable.setPackageName("com.ximai.mes.md");
        genTable.setModuleName("md");
        genTable.setBusinessName("md.basic");
        genTable.setFunctionName("BOM");
        genTable.setFunctionAuthor("chicheng.li");
        genTable.setGenPath("/");
        genTableService.generatorCode(genTable);

    }
}
