package com.ximai.common.utils.excel.converter;

import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.GlobalConfiguration;
import com.alibaba.excel.metadata.data.ReadCellData;
import com.alibaba.excel.metadata.property.ExcelContentProperty;
import io.netty.util.internal.StringUtil;

/**
 * 是否转换器
 * @ Author: chicheng.li
 * @ Date  : 2022/2/16
 */
public class WhetherConverter implements Converter<Boolean> {
    public static final String YES = "是";
    public static final String NO = "否";

    @Override
    public Class supportJavaTypeKey() {
        return Boolean.class;
    }

    @Override
    public CellDataTypeEnum supportExcelTypeKey() {
        return CellDataTypeEnum.STRING;
    }

    @Override
    public Boolean convertToJavaData(ReadCellData<?> cellData, ExcelContentProperty excelContentProperty, GlobalConfiguration globalConfiguration) throws Exception {
        String stringValue = cellData.getStringValue();
        Boolean booleanValue = cellData.getBooleanValue();
        if(StringUtil.isNullOrEmpty(stringValue)){
            if(cellData.getNumberValue()!=null){
                stringValue = cellData.getNumberValue().intValue()+"";
            }
        }
        if (YES.equals(stringValue) || "1".equals(stringValue) || booleanValue==true){
            return true;
        }else {
            return false;
        }
    }

}
