package com.ximai.common.utils.excel;

import com.alibaba.excel.EasyExcel;

import java.io.InputStream;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public class ExcelReader {
    public static <T> void read(InputStream inputStream, Class<T> head, Consumer<T> header){
        EasyExcel.read(inputStream, head, new ExcelReadListener<T>(header)).ignoreEmptyRow(true).sheet().autoTrim(true).doRead();
    }
    public static <T> void read(InputStream inputStream, Class<T> head, BiConsumer<T, Boolean> header, Boolean isUpdateSupport){
        EasyExcel.read(inputStream, head, new ExcelReadListener<T>(header, isUpdateSupport)).ignoreEmptyRow(true).sheet().autoTrim(true).doRead();
    }
}
