package com.ximai.common.utils.data;

import lombok.Data;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Objects;
import java.util.UUID;

public class DataUtil {

//
//    public static void main(String[] args) {
//        // Example usage
//        Source source = new Source();
//        source.setName("1111");
//        source.setAge(111);
//
//        Target target = new Target();
//        target.setName("Target");
//        target.setAge(11);
//
//        copyFieldsAndSetValues(source, target);
//
//        System.out.println(target.getName()); // Output: Source
//        System.out.println(target.getAge());  // Output: 25
//    }

    public static String getUuid() {
        UUID uuid = UUID.randomUUID();
        return uuid.toString().replace("-", "");
    }

    @Data
    static class Source {
        private String name;
        private Integer age;
    }

    @Data
    static class Target {
        private String name;
        private Integer age;
    }

    public static boolean checkNumeric(String input) {
        return input.chars().allMatch(Character::isDigit);
    }


    public static void copyFieldsAndSetValues(Object source, Object target) {
        if (source == null || target == null) {
            return;
        }
        Field[] sourceFields = source.getClass().getDeclaredFields();
        for (Field sourceField : sourceFields) {
            sourceField.setAccessible(true);
            try {
                Object value = sourceField.get(source);
                if (StringUtils.isNotEmpty(value)) {
                    if (!Objects.equals(value.toString(), "0")) {
                        Field targetField = target.getClass().getDeclaredField(sourceField.getName());
                        targetField.setAccessible(true);
                        if (targetField.isAccessible()) {
                            targetField.set(target, value);
                        }
                    }

                }
            } catch (Exception e) {
                // Ignore the exception and continue with the next field
            }
        }
    }

    //
//    public static String getDateStr(Date oldDate, String pattern) {
//        if (oldDate == null) {
//            return format(new Date(), pattern);
//        } else {
//            return format(oldDate, pattern);
//        }
//    }
//
//    public static <T> T getNormalData(Object nowObj, Class<T> clz) {
//        T t = null;
//        if (nowObj == null) {
//            try {
//                if (clz.equals(BigDecimal.class)) {
//                    t = (T) BigDecimal.ZERO;
//                } else if (clz.equals(Integer.class)) {
//                    // 反射创建BigDecimal实例
//                    t = (T) new Integer(0);
//                } else if (clz.equals(Long.class)) {
//                    t = (T) new Long(0);
//                } else if (clz.equals(Double.class)) {
//                    t = (T) new Double(0);
//                } else if (clz.equals(String.class)) {
//                    // 反射创建BigDecimal实例
//                    t = clz.newInstance();
//                } else if (clz.equals(Date.class)) {
//                    // 反射创建BigDecimal实例
//                    t = (T) new Date();
//                }
//            } catch (InstantiationException | IllegalAccessException e) {
//                throw new RuntimeException(e);
//            }
//        }
//        return t;
//    }
//
    public static BigDecimal getNormalData(BigDecimal nowObj) {
        return getNormalData(nowObj, BigDecimal.class);
    }


    public static Integer getNormalData(Integer nowObj) {
        return getNormalData(nowObj, Integer.class);
    }

    public static String removeLeftZeros(String str) {
        return str.replaceAll("^0+", "");
    }

    public static Long getNormalData(Long nowObj) {
        return getNormalData(nowObj, Long.class);
    }


    public static Double getNormalData(Double nowObj) {
        return getNormalData(nowObj, Double.class);
    }


    public static String getNormalData(String nowObj) {
        return getNormalData(nowObj, String.class);
    }


    public static Date getNormalData(Date nowObj) {
        return getNormalData(nowObj, Date.class);
    }


//    public static <T> T getNewData(Object nowObj, T t, T normal) {
////        t.getClass().isInstance()
//        if (t == null) {
//            try {
//                t = normal;
////                if (clz.equals(BigDecimal.class)) {
//////                    // 获取BigDecimal的构造函数
//////                    final Constructor<BigDecimal> constructor = BigDecimal.class.getDeclaredConstructor(int.class);
////////                    final Constructor<BigDecimal> constructor = BigDecimal.class.getDeclaredConstructor(char[].class, int.class, int.class);
//////
//////                    AccessController.doPrivileged((PrivilegedAction<Void>) () -> {
//////                        constructor.setAccessible(true); // 使构造函数可访问
//////                        return null;
//////                    });
//////
//////                    // 反射创建BigDecimal实例
//////                    t = (T) constructor.newInstance(0);
////                    t = (T) BigDecimal.ZERO;
////                } else if (clz.equals(Integer.class)) {
////                    // 反射创建BigDecimal实例
////                    t = (T) new Integer(0);
////                } else if (clz.equals(Long.class)) {
////                    t = (T) new Long(0);
////                } else if (clz.equals(Double.class)) {
////                    t = (T) new Double(0);
////                } else if (clz.equals(String.class)) {
////                    // 反射创建BigDecimal实例
////                    t = clz.newInstance();
////                } else if (clz.equals(Date.class)) {
////                    // 反射创建BigDecimal实例
////                    t = (T) new Date();
////                }
//            } catch (InstantiationException | IllegalAccessException e) {
//                throw new RuntimeException(e);
//            }
//        }
//        return getNewData(nowObj, t);
//    }
//
//    public static void main(String[] args) {
////        System.out.println(getNewData(new Date(), new Date()));
////        System.out.println(getNewData(null, null, Date.class));
////        System.out.println(repliceData(null, new Date()));
////        System.out.println(getNormalData(null, String.class));
////        System.out.println(getNormalData(null, Date.class));
////        System.out.println(getNormalData(null, Integer.class));
////        System.out.println(getNormalData(null, 2));
//
//
//        if (CLASS_FORMAT[0].equalsIgnoreCase("java.math.BIGDECIMAL")) {
//
//            System.out.println("java.math.BigDecimal");
//        }
//
//    }

    public static <T> T repliceData(T t1, T t2) {
        if (t1 == null && t2 == null) {
            return null;
        }

        if (t2 == null) {
            return t1;
        } else {
            return t2;
        }
    }


    // 获取默认值
    public static <T> T getNormalData(Object obj, Class<T> clazz) {
        return getNormalData(obj, null, clazz.toString());
    }

    // 设置默认值
    public static <T> T getNormalData(Object obj, T t) {
        String clzStr = t.getClass().toString();
        return getNormalData(obj, t, clzStr);
    }

    // 设置默认值
    public static <T> T getNormalData(Object obj, T t, Class<T> clazz) {
        return getNormalData(obj, t, clazz.toString());
    }


    public static final String[] CLASS_FORMAT = {
            "java.math.BigDecimal", "java.lang.Integer", "java.lang.String", "java.lang.Double", "java.util.Date", "java.lang.Long"};

    // 设置默认值
    public static <T> T getNormalData(Object c1, T c2, String clazzStr) {
// class java.lang.String
//class java.math.BigDecimal
//class java.lang.Integer
//class java.lang.Long
//class java.lang.Double
//class java.util.Date

        Object result = null;
        if (c2 != null) {
            result = c2;
        }

        if (c1 != null) {
            result = c1;
        }

        String clzStr = clazzStr.replace("class ", "");

        if (CLASS_FORMAT[0].equalsIgnoreCase(clzStr)) {
            result = result == null ? BigDecimal.ZERO : new BigDecimal(result.toString());
        } else if (CLASS_FORMAT[1].equalsIgnoreCase(clzStr)) {
            result = result == null ? 0 : Integer.parseInt(result.toString());
        } else if (CLASS_FORMAT[5].equalsIgnoreCase(clzStr)) {
            result = result == null ? 0L : Long.parseLong(result.toString());
        } else if (CLASS_FORMAT[3].equalsIgnoreCase(clzStr)) {
            result = result == null ? 0D : Double.parseDouble(result.toString());
        } else if (CLASS_FORMAT[2].equalsIgnoreCase(clzStr)) {
            result = result == null ? "" : result.toString();
        } else if (CLASS_FORMAT[4].equalsIgnoreCase(clzStr)) {
            result = result == null ? new Date() : result;
        }

        if (result == null) {
            return null;
        }
        return (T) result;
    }


}
