package com.ximai.common.core.domain;


import com.ximai.common.constant.HttpStatus;

/**
 * 操作消息提醒
 */
public class SapAjaxResult<T> {
    private static final long serialVersionUID = 1L;

    /**
     * 状态码
     */
    public String code;

    /**
     * 返回内容
     */
    public String msg;

    /**
     * 数据对象
     */
    public T data;

    /**
     * 初始化一个新创建的 AjaxResult 对象，使其表示一个空消息。
     */
    public SapAjaxResult() {
    }

    /**
     * 初始化一个新创建的 AjaxResult 对象
     *
     * @param code 状态码
     * @param msg  返回内容
     */
    public SapAjaxResult(String code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    /**
     * 初始化一个新创建的 AjaxResult 对象
     *
     * @param code 状态码
     * @param msg  返回内容
     * @param data 数据对象
     */
    public SapAjaxResult(String code, String msg, T data) {
        this.code = code;
        this.msg = msg;
        this.data = data;
    }

    /**
     * 返回成功消息
     *
     * @return 成功消息
     */
    public static <T> SapAjaxResult<T> success() {
        return SapAjaxResult.success("操作成功");
    }

    /**
     * 返回成功数据
     *
     * @return 成功消息
     */
    public static <T> SapAjaxResult<T> success(T data) {
        return SapAjaxResult.success("操作成功", data);
    }

    /**
     * 返回成功消息
     *
     * @param msg 返回内容
     * @return 成功消息
     */
    public static <T> SapAjaxResult<T> success(String msg) {
        return SapAjaxResult.success(msg, null);
    }

    /**
     * 返回成功消息
     *
     * @param msg  返回内容
     * @param data 数据对象
     * @return 成功消息
     */
    public static <T> SapAjaxResult success(String msg, T data) {
        return new SapAjaxResult(HttpStatus.SAP_SUCCESS, msg, data);
    }


    /**
     * 返回错误消息
     *
     * @return
     */
    public static SapAjaxResult error() {
        return SapAjaxResult.error("操作失败");
    }

    /**
     * 返回错误消息
     *
     * @param msg 返回内容
     * @return 警告消息
     */
    public static <T> SapAjaxResult<T> error(String msg) {
        return SapAjaxResult.error(msg, null);
    }

    /**
     * 返回错误消息
     *
     * @param msg  返回内容
     * @param data 数据对象
     * @return 警告消息
     */
    public static <T> SapAjaxResult<T> error(String msg, T data) {
        return new SapAjaxResult(HttpStatus.SAP_FAILD, msg, data);
    }


    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public T getData() {
        return data;
    }

    public void setData(T data) {
        this.data = data;
    }
}
