package com.ximai.mes.tm.service.impl;

import com.ximai.common.utils.data.DateUtils;
import com.ximai.common.utils.SecurityUtils;
import com.ximai.mes.tm.domain.TmToolMachines;
import com.ximai.mes.tm.domain.TmToolMachinesRecord;
import com.ximai.mes.tm.mapper.TmToolMachinesMapper;
import com.ximai.mes.tm.mapper.TmToolMachinesRecordMapper;
import com.ximai.mes.tm.service.ITmToolMachinesRecordService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 刀模版上下机记录Service业务层处理
 *
 * @author generator
 * @date 2024-02-06
 */
@Service
public class TmToolMachinesRecordServiceImpl implements ITmToolMachinesRecordService {
    @Autowired
    private TmToolMachinesRecordMapper tmToolMachinesRecordMapper;

    @Autowired
    private TmToolMachinesMapper tmToolMachinesMapper;

    /**
     * 查询刀模版上下机记录
     *
     * @param toolMachinesRecordId 刀模版上下机记录主键
     * @return 刀模版上下机记录
     */
    @Override
    public TmToolMachinesRecord selectTmToolMachinesRecordByToolMachinesRecordId(Long toolMachinesRecordId) {
//        return tmToolMachinesRecordMapper.selectTmToolMachinesRecordByToolMachinesRecordId(toolMachinesRecordId);
        return null;
    }

    /**
     * 查询刀模版上下机记录列表
     *
     * @param tmToolMachinesRecord 刀模版上下机记录
     * @return 刀模版上下机记录
     */
    @Override
    public List<TmToolMachinesRecord> selectTmToolMachinesRecordList(TmToolMachinesRecord tmToolMachinesRecord) {
        return tmToolMachinesRecordMapper.selectTmToolMachinesRecordList(tmToolMachinesRecord);
    }

    @Override
    public TmToolMachinesRecord selectByToolMachinesRecordId(Long toolMachinesRecordId) {
        return tmToolMachinesRecordMapper.selectByToolMachinesRecordId(toolMachinesRecordId);
    }

    /**
     * 新增刀模版上下机记录
     *
     * @param tmToolMachinesRecord 刀模版上下机记录
     * @return 结果
     */
    @Override
    public int insertTmToolMachinesRecord(TmToolMachinesRecord tmToolMachinesRecord) {
        tmToolMachinesRecord.setCreateBy(SecurityUtils.getUsername());
        tmToolMachinesRecord.setCreateTime(DateUtils.getNowDate());
        return tmToolMachinesRecordMapper.insertTmToolMachinesRecord(tmToolMachinesRecord);
    }

    /**
     * 修改刀模版上下机记录
     *
     * @param tmToolMachinesRecord 刀模版上下机记录
     * @return 结果
     */
    @Override
    public int updateTmToolMachinesRecord(TmToolMachinesRecord tmToolMachinesRecord) {
        tmToolMachinesRecord.setUpdateBy(SecurityUtils.getUsername());
        tmToolMachinesRecord.setUpdateTime(DateUtils.getNowDate());
        return tmToolMachinesRecordMapper.updateTmToolMachinesRecord(tmToolMachinesRecord);
    }

    /**
     * 批量删除刀模版上下机记录
     *
     * @param toolMachinesRecordIds 需要删除的刀模版上下机记录主键
     * @return 结果
     */
    @Override
    public int deleteTmToolMachinesRecordByToolMachinesRecordIds(Long[] toolMachinesRecordIds) {
        return tmToolMachinesRecordMapper.deleteTmToolMachinesRecordByToolMachinesRecordIds(toolMachinesRecordIds);
    }

    /**
     * 删除刀模版上下机记录信息
     *
     * @param toolMachinesRecordId 刀模版上下机记录主键
     * @return 结果
     */
    @Override
    public int deleteTmToolMachinesRecordByToolMachinesRecordId(Long toolMachinesRecordId) {
        return tmToolMachinesRecordMapper.deleteTmToolMachinesRecordByToolMachinesRecordId(toolMachinesRecordId);
    }

    @Override
    public List<TmToolMachines> getRecordsByProcessIdAndArrangeCode(TmToolMachines tmToolMachines) {
        return tmToolMachinesMapper.selectTmToolMachinesVoList(tmToolMachines);
    }
}
