package com.ximai.mes.restful;


import com.alibaba.fastjson.JSON;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.mes.wm.domain.vo.WmIssueVo;
import com.ximai.mes.wm.service.IWmIssueHeaderService;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@RestController
@RequestMapping(value = "/apiPda/issue")
public class PdaIssueRestController {

    @Autowired
    private IWmIssueHeaderService wmIssueHeaderService;


    @ApiOperation(value = "领料单创建")
    @RequestMapping(value = "/pdaissuecreate", method = RequestMethod.POST)
    public AjaxResult sapIssueCreate(@RequestBody String tmIssueJson) {
        List<WmIssueVo> wmIssueVos = JSON.parseArray(tmIssueJson, WmIssueVo.class);
        wmIssueHeaderService.sapCreateObj(wmIssueVos);
        return AjaxResult.success("操作成功");
    }


}
