package com.ximai.mes.qc.service;

import com.ximai.mes.qc.domain.QcAbnormalReport;

import java.util.List;

/**
 * 车间异常单Service接口
 *
 * @author generator
 * @date 2024-02-20
 */
public interface IQcAbnormalReportService {
    /**
     * 查询车间异常单
     *
     * @param abnormalReportId 车间异常单主键
     * @return 车间异常单
     */
    QcAbnormalReport selectQcAbnormalReportByAbnormalReportId(Long abnormalReportId);

    /**
     * 查询车间异常单列表
     *
     * @param qcAbnormalReport 车间异常单
     * @return 车间异常单集合
     */
    List<QcAbnormalReport> selectQcAbnormalReportList(QcAbnormalReport qcAbnormalReport);

    /**
     * 新增车间异常单
     *
     * @param qcAbnormalReport 车间异常单
     * @return 结果
     */
    int insertObj(QcAbnormalReport qcAbnormalReport);

    int insertQcAbnormalReport(QcAbnormalReport qcAbnormalReport);

    /**
     * 修改车间异常单
     *
     * @param qcAbnormalReport 车间异常单
     * @return 结果
     */
    int updateQcAbnormalReport(QcAbnormalReport qcAbnormalReport);

    /**
     * 批量删除车间异常单
     *
     * @param abnormalReportIds 需要删除的车间异常单主键集合
     * @return 结果
     */
    int deleteQcAbnormalReportByAbnormalReportIds(Long[] abnormalReportIds);

    /**
     * 删除车间异常单信息
     *
     * @param abnormalReportId 车间异常单主键
     * @return 结果
     */
    int deleteQcAbnormalReportByAbnormalReportId(Long abnormalReportId);

    /**
     * 完成按钮的功能实现
     *
     * @param abnormalReportIds 车间异常单主键
     * @return 结果
     */
    void updateQcAbnormalReportAbmornalStatud(QcAbnormalReport qcAbnormalReport);

    String getAbnormalNumber();

    void start(Long abnormalReportIds);
}
