package com.ximai.mes.pro.service.prototypeMake;

import java.util.List;
import com.ximai.mes.pro.domain.prototypeMake.ProPrototypeMakeProcessItem;

/**
 * 样品制作工序物料Service接口
 *
 * @author yinjinlu
 * @date 2024-01-20
 */
public interface IProPrototypeMakeProcessItemService
{
    /**
     * 查询样品制作工序物料
     *
     * @param prototypeMakeProcessItemId 样品制作工序物料主键
     * @return 样品制作工序物料
     */
    public ProPrototypeMakeProcessItem selectProPrototypeMakeProcessItemByPrototypeMakeProcessItemId(Long prototypeMakeProcessItemId);

    /**
     * 查询样品制作工序物料列表
     *
     * @param proPrototypeMakeProcessItem 样品制作工序物料
     * @return 样品制作工序物料集合
     */
    public List<ProPrototypeMakeProcessItem> selectProPrototypeMakeProcessItemList(ProPrototypeMakeProcessItem proPrototypeMakeProcessItem);

    /**
     * 新增样品制作工序物料
     *
     * @param proPrototypeMakeProcessItem 样品制作工序物料
     * @return 结果
     */
    public int insertProPrototypeMakeProcessItem(ProPrototypeMakeProcessItem proPrototypeMakeProcessItem);

    /**
     * 修改样品制作工序物料
     *
     * @param proPrototypeMakeProcessItem 样品制作工序物料
     * @return 结果
     */
    public int updateProPrototypeMakeProcessItem(ProPrototypeMakeProcessItem proPrototypeMakeProcessItem);

    /**
     * 批量删除样品制作工序物料
     *
     * @param prototypeMakeProcessItemIds 需要删除的样品制作工序物料主键集合
     * @return 结果
     */
    public int deleteProPrototypeMakeProcessItemByPrototypeMakeProcessItemIds(Long[] prototypeMakeProcessItemIds);

    /**
     * 删除样品制作工序物料信息
     *
     * @param prototypeMakeProcessItemId 样品制作工序物料主键
     * @return 结果
     */
    public int deleteProPrototypeMakeProcessItemByPrototypeMakeProcessItemId(Long prototypeMakeProcessItemId);
}
