package com.ximai.mes.md.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.IService;
import com.ximai.mes.md.domain.MdClientAccount;

import java.util.List;
import java.util.Map;
/**
 * 客户付款信息Service接口
 *
 * @author generator
 * @date 2024-01-27
 */
public interface IMdClientAccountService extends IService<MdClientAccount> {

    /**
     * 分页查询
     *
     * @param params 分页参数
     * @return 分页结果
     */
    IPage<MdClientAccount> page(Map<String, Object> params);

    /**
     * 查询客户付款信息
     *
     * @param id 客户付款信息主键
     * @return 客户付款信息
     */
    MdClientAccount selectById(Long id);

    /**
     * 查询客户付款信息列表
     *
     * @param mdClientAccount 客户付款信息
     * @return 客户付款信息集合
     */
    List<MdClientAccount> selectList(MdClientAccount mdClientAccount);

    /**
     * 新增客户付款信息
     *
     * @param mdClientAccount 客户付款信息
     * @return 结果
     */
    Boolean insert(MdClientAccount mdClientAccount);

    /**
     * 修改客户付款信息
     *
     * @param mdClientAccount 客户付款信息
     * @return 结果
     */
    Boolean update(MdClientAccount mdClientAccount);

    /**
     * 批量删除客户付款信息
     *
     * @param ids 需要删除的客户付款信息主键集合
     * @return 结果
     */
    Boolean deleteByIds(List<Long> ids);

    /**
     * 删除客户付款信息信息
     *
     * @param id 客户付款信息主键
     * @return 结果
     */
    Boolean deleteById(Long id);
}
