package com.ximai.mes.md.domain;

import java.util.Date;

import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ximai.common.annotation.Excel;
import com.baomidou.mybatisplus.annotation.TableId;
import com.ximai.common.core.domain.BaseEntity;

/**
 * 车辆列表对象 md_vehicle
 *
 * @author generator
 * @date 2024-01-25
 */
@TableName("md_vehicle")
public class MdVehicle extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** $column.columnComment */
    @TableId
    private Long vehicleId;

    /** 车辆编码 */
    private String vehicleCode;

    /** 车辆名称 */
    @Excel(name = "车辆名称")
    private String vehicleName;

    /** 车牌号 */
    @Excel(name = "车牌号")
    private String licensePlate;

    /** 车型 */
    @Excel(name = "车型")
    private String vehicleModel;

    /** 座位数 */
    @Excel(name = "座位数")
    private Integer seating;

    /** 购买时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "购买时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date purchaseDate;

    /** 验车时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "验车时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date inspectionDate;

    public void setVehicleId(Long vehicleId)
    {
        this.vehicleId = vehicleId;
    }

    public Long getVehicleId()
    {
        return vehicleId;
    }
    public void setVehicleCode(String vehicleCode)
    {
        this.vehicleCode = vehicleCode;
    }

    public String getVehicleCode()
    {
        return vehicleCode;
    }
    public void setVehicleName(String vehicleName)
    {
        this.vehicleName = vehicleName;
    }

    public String getVehicleName()
    {
        return vehicleName;
    }

    public String getLicensePlate() {
        return licensePlate;
    }

    public void setLicensePlate(String licensePlate)
    {
        this.licensePlate = licensePlate;
    }

    public String getVehicleModel() {
        return vehicleModel;
    }

    public void setVehicleModel(String vehicleModel) {
        this.vehicleModel = vehicleModel;
    }

    public Integer getSeating()
    {
        return seating;
    }

    public void setSeating(Integer seating) {
        this.seating = seating;
    }

    public void setPurchaseDate(Date purchaseDate)
    {
        this.purchaseDate = purchaseDate;
    }

    public Date getPurchaseDate()
    {
        return purchaseDate;
    }
    public void setInspectionDate(Date inspectionDate)
    {
        this.inspectionDate = inspectionDate;
    }

    public Date getInspectionDate()
    {
        return inspectionDate;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("vehicleId", getVehicleId())
            .append("vehicleCode", getVehicleCode())
            .append("vehicleName", getVehicleName())
            .append("licensePlate", getLicensePlate())
            .append("vehicleMod", getVehicleModel())
            .append("seating", getSeating())
            .append("purchaseDate", getPurchaseDate())
            .append("inspectionDate", getInspectionDate())
            .append("remark", getRemark())
            .append("createBy", getCreateBy())
            .append("createTime", getCreateTime())
            .append("updateBy", getUpdateBy())
            .append("updateTime", getUpdateTime())
            .toString();
    }
}
