package com.ximai.mes.remote;

import com.ximai.common.annotation.ApiLog;
import com.ximai.common.enums.BusinessType;
import com.ximai.common.enums.InOutType;
import com.ximai.mes.kanban.dto.material.ErpDataDto;
import com.ximai.mes.remote.dto.*;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;

import java.util.List;

/**
 * erp远程调用接口
 */
@FeignClient(value = "erp-kanbanService", url = "${remote.erp.url}")
public interface ErpKanbanService {

    @ApiLog(businessType = BusinessType.QUERY, inOutType = InOutType.OUT)
    @ApiOperation(value = "物料看板ERP数据")
    @PostMapping(value = "/materialStat/allData")
    ErpResponseResult<ErpDataDto> getMaterialStat();

}
