package com.ximai.mes.pro.service.task;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ximai.mes.pro.domain.ProFeedback;
import com.ximai.mes.pro.domain.task.ProTaskAssistProcess;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * 工序任务外协关系Service接口
 *
 * @author generator
 * @date 2024-03-29
 */
public interface IProTaskAssistProcessService {

    /**
     * 查询工序任务外协关系
     *
     * @param id 工序任务外协关系主键
     * @return 工序任务外协关系
     */
    ProTaskAssistProcess selectProTaskAssistProcessById(Long id);

    List<ProTaskAssistProcess> selectListByObj(ProTaskAssistProcess proTaskAssistProcesses);


    List<ProTaskAssistProcess> selectListByQw(QueryWrapper<ProTaskAssistProcess> qw);

    ProTaskAssistProcess selectBaseByObj(ProTaskAssistProcess proTaskAssistProcesses);

    /**
     * 新增工序任务外协关系
     *
     * @param proTaskAssistprocess 工序任务外协关系
     * @return 结果
     */
    int insertProTaskAssistProcess(ProTaskAssistProcess proTaskAssistprocess);


    /**
     * 修改工序任务外协关系
     *
     * @param proTaskAssistprocess 工序任务外协关系
     * @return 结果
     */
    int updateProTaskAssistprocess(ProTaskAssistProcess proTaskAssistprocess);

    int updateObj(ProTaskAssistProcess proTaskAssistprocess);

    int updateProTaskAssistProcess(ProTaskAssistProcess proTaskAssistprocess);


    /**
     * 批量删除工序任务外协关系
     *
     * @param ids 需要删除的工序任务外协关系主键集合
     * @return 结果
     */
    int deleteProTaskAssistProcessByIds(Long[] ids);

    /**
     * 删除工序任务外协关系信息
     *
     * @param id 工序任务外协关系主键
     * @return 结果
     */
    int deleteProTaskAssistProcessById(Long id);

    @Transactional
    int feedBack(ProFeedback proFeedback);


    int insertObj(ProTaskAssistProcess proTaskAssistprocess);

//    int feedBackSap(ProTaskAssistProcess proTaskAssistprocess);

    int deleteObj(ProTaskAssistProcess proTaskAssistProcess);

    Boolean queryAssistProcessIsCompleted(String code);

    List<ProTaskAssistProcess> listUnreportedFeedback(ProTaskAssistProcess proTaskAssistProcess);

    List<ProTaskAssistProcess> getAssistProcesslist(ProTaskAssistProcess proTaskAssistProcess);
}
