package com.ximai.mes.pro.service.impl.task;

import java.util.List;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ximai.common.utils.data.DateUtils;
import com.ximai.common.utils.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import cn.hutool.core.bean.BeanUtil;
import com.ximai.mes.pro.mapper.task.ProTaskWorkunitConvertRecordMapper;
import com.ximai.mes.pro.domain.task.ProTaskWorkunitConvertRecord;
import com.ximai.mes.pro.dto.task.ProTaskWorkunitConvertRecordCreate;
import com.ximai.mes.pro.dto.task.ProTaskWorkunitConvertRecordUpdate;
import com.ximai.mes.pro.dto.task.ProTaskWorkunitConvertRecordDto;
import com.ximai.mes.pro.service.task.IProTaskWorkunitConvertRecordService;

/**
 * 任务派工转换记录Service业务层处理
 *
 * @author generator
 * @date 2024-09-20
 */
@Service
public class ProTaskWorkunitConvertRecordServiceImpl implements IProTaskWorkunitConvertRecordService
{
    @Autowired
    private ProTaskWorkunitConvertRecordMapper proTaskWorkunitConvertRecordMapper;

    /**
     * 查询任务派工转换记录
     *
     * @param id 任务派工转换记录主键
     * @return 任务派工转换记录
     */
    @Override
    public ProTaskWorkunitConvertRecordDto selectProTaskWorkunitConvertRecordDtoById(Long id) {
        return proTaskWorkunitConvertRecordMapper.selectProTaskWorkunitConvertRecordById(id);
    }

    /**
     * 查询任务派工转换记录
     *
     * @param id 任务派工转换记录主键
     * @return 任务派工转换记录
     */
    @Override
    public ProTaskWorkunitConvertRecord selectProTaskWorkunitConvertRecordById(Long id) {
        return proTaskWorkunitConvertRecordMapper.selectById(id);
    }

    /**
     * 查询任务派工转换记录列表
     *
     * @param proTaskWorkunitConvertRecord 任务派工转换记录
     * @return 任务派工转换记录
     */
    @Override
    public List<ProTaskWorkunitConvertRecordDto> selectProTaskWorkunitConvertRecordList(ProTaskWorkunitConvertRecord proTaskWorkunitConvertRecord) {
        return proTaskWorkunitConvertRecordMapper.selectProTaskWorkunitConvertRecordList(proTaskWorkunitConvertRecord);
    }

    /**
     * 查询任务派工转换记录列表
     *
     * @param proTaskWorkunitConvertRecordQuery 任务派工转换记录
     * @return 任务派工转换记录
     */
    @Override
    public List<ProTaskWorkunitConvertRecord> selectProTaskWorkunitConvertRecordList(QueryWrapper<ProTaskWorkunitConvertRecord> proTaskWorkunitConvertRecordQuery) {
        return proTaskWorkunitConvertRecordMapper.selectList(proTaskWorkunitConvertRecordQuery);
    }

    /**
     * 查询任务派工转换记录列表
     *
     * @param proTaskWorkunitConvertRecordQuery 任务派工转换记录
     * @return 任务派工转换记录
     */
    @Override
    public List<ProTaskWorkunitConvertRecordDto> selectProTaskWorkunitConvertRecordDtoList(QueryWrapper<ProTaskWorkunitConvertRecord> proTaskWorkunitConvertRecordQuery) {
        return proTaskWorkunitConvertRecordMapper.selectDtoListByQw(proTaskWorkunitConvertRecordQuery);
    }

    /**
     * 新增任务派工转换记录
     *
     * @param proTaskWorkunitConvertRecordCreate 任务派工转换记录
     * @return 结果
     */
    @Override
    public int insertProTaskWorkunitConvertRecord(ProTaskWorkunitConvertRecordCreate proTaskWorkunitConvertRecordCreate) {

        ProTaskWorkunitConvertRecord proTaskWorkunitConvertRecord = new ProTaskWorkunitConvertRecord();
        BeanUtil.copyProperties(proTaskWorkunitConvertRecordCreate, proTaskWorkunitConvertRecord);
        proTaskWorkunitConvertRecord.setCreateBy(SecurityUtils.getUsername());
        proTaskWorkunitConvertRecord.setCreateTime(DateUtils.getNowDate());
        return proTaskWorkunitConvertRecordMapper.insertProTaskWorkunitConvertRecord(proTaskWorkunitConvertRecord);
    }

    /**
     * 修改任务派工转换记录
     *
     * @param proTaskWorkunitConvertRecordUpdate 任务派工转换记录
     * @return 结果
     */
    @Override
    public int updateProTaskWorkunitConvertRecord(ProTaskWorkunitConvertRecordUpdate proTaskWorkunitConvertRecordUpdate) {
        ProTaskWorkunitConvertRecord proTaskWorkunitConvertRecord = new ProTaskWorkunitConvertRecord();
        BeanUtil.copyProperties(proTaskWorkunitConvertRecordUpdate, proTaskWorkunitConvertRecord);
        return proTaskWorkunitConvertRecordMapper.updateProTaskWorkunitConvertRecord(proTaskWorkunitConvertRecord);
    }

    /**
     * 批量删除任务派工转换记录
     *
     * @param ids 需要删除的任务派工转换记录主键
     * @return 结果
     */
    @Override
    public int deleteProTaskWorkunitConvertRecordByIds(Long[] ids) {
        return proTaskWorkunitConvertRecordMapper.deleteProTaskWorkunitConvertRecordByIds(ids);
    }

    /**
     * 删除任务派工转换记录信息
     *
     * @param id 任务派工转换记录主键
     * @return 结果
     */
    @Override
    public int deleteProTaskWorkunitConvertRecordById(Long id) {
        return proTaskWorkunitConvertRecordMapper.deleteProTaskWorkunitConvertRecordById(id);
    }
}
