package com.ximai.mes.pro.mapper.prototypeMake;

import java.util.List;
import com.ximai.mes.pro.domain.prototypeMake.ProPrototypeMakeBom;

/**
 * 样品制作BOMMapper接口
 *
 * @author zht
 * @date 2024-01-20
 */
public interface ProPrototypeMakeBomMapper
{
    /**
     * 查询样品制作BOM
     *
     * @param bomItemId 样品制作BOM主键
     * @return 样品制作BOM
     */
    public ProPrototypeMakeBom selectProPrototypeMakeBomByBomItemId(Long bomItemId);

    /**
     * 查询样品制作BOM列表
     *
     * @param proPrototypeMakeBom 样品制作BOM
     * @return 样品制作BOM集合
     */
    public List<ProPrototypeMakeBom> selectProPrototypeMakeBomList(ProPrototypeMakeBom proPrototypeMakeBom);

    /**
     * 新增样品制作BOM
     *
     * @param proPrototypeMakeBom 样品制作BOM
     * @return 结果
     */
    public int insertProPrototypeMakeBom(ProPrototypeMakeBom proPrototypeMakeBom);

    /**
     * 修改样品制作BOM
     *
     * @param proPrototypeMakeBom 样品制作BOM
     * @return 结果
     */
    public int updateProPrototypeMakeBom(ProPrototypeMakeBom proPrototypeMakeBom);

    /**
     * 删除样品制作BOM
     *
     * @param bomItemId 样品制作BOM主键
     * @return 结果
     */
    public int deleteProPrototypeMakeBomByBomItemId(Long bomItemId);

    /**
     * 批量删除样品制作BOM
     *
     * @param bomItemIds 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteProPrototypeMakeBomByBomItemIds(Long[] bomItemIds);

    List<ProPrototypeMakeBom> selectProPrototypeMakeBomByPrototypeMakeId(Long prototypeMakeId);
}
