package com.ximai.mes.pro.domain.vo.proWorkOrder;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 *  打样工单生成
 *
 * @date 2024/04/25
 */
@Data
public class WorkorderProofMakeProduction  {

    @ApiModelProperty("工单ID")
    Long workorderId;

    @ApiModelProperty("工艺数据")
    List<WorkorderProofMakeProductionProcess> processData;

    @Data
    public static class WorkorderProofMakeProductionProcess{

        @ApiModelProperty("工单工序ID")
        private Long workorderProcessId;

        @ApiModelProperty("计划开始时间")
        @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
        private Date scheduleStartTime;

        @ApiModelProperty("计划结束时间")
        @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
        private Date scheduleEndTime;

        @ApiModelProperty("作业单元ID")
        private Long workunitId;
    }


}
