package com.ximai.mes.md.mapper;

import java.util.List;
import com.ximai.mes.md.domain.MdProductFactory;
import com.ximai.mes.md.vo.MdProductFactoryVo;

/**
 * 产品工厂配置Mapper接口
 *
 * @author yinjinlu
 * @date 2024-01-17
 */
public interface MdProductFactoryMapper
{
    /**
     * 查询产品工厂配置
     *
     * @param productFactoryId 产品工厂配置主键
     * @return 产品工厂配置
     */
    public MdProductFactory selectMdProductFactoryByProductFactoryId(Long productFactoryId);

    /**
     * 查询产品工厂配置列表
     *
     * @param mdProductFactory 产品工厂配置
     * @return 产品工厂配置集合
     */
    public List<MdProductFactoryVo> selectMdProductFactoryList(MdProductFactory mdProductFactory);

    /**
     * 新增产品工厂配置
     *
     * @param mdProductFactory 产品工厂配置
     * @return 结果
     */
    public int insertMdProductFactory(MdProductFactory mdProductFactory);

    /**
     * 修改产品工厂配置
     *
     * @param mdProductFactory 产品工厂配置
     * @return 结果
     */
    public int updateMdProductFactory(MdProductFactory mdProductFactory);

    /**
     * 删除产品工厂配置
     *
     * @param productFactoryId 产品工厂配置主键
     * @return 结果
     */
    public int deleteMdProductFactoryByProductFactoryId(Long productFactoryId);

    /**
     * 批量删除产品工厂配置
     *
     * @param productFactoryIds 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteMdProductFactoryByProductFactoryIds(Long[] productFactoryIds);
}
