package com.bs.mes.workorder;

import com.ximai.mes.pro.domain.proWorkOrder.ProWorkOrderSoDirective;
import com.ximai.mes.pro.domain.proWorkOrder.ProWorkOrderSoSizeItem;
import com.ximai.mes.pro.domain.vo.proWorkOrder.BuildPackageParams2;
import com.ximai.mes.pro.domain.vo.proWorkOrder.PackageBasicData;
import com.ximai.mes.pro.domain.vo.proWorkOrder.PackageBasicResult;
import com.ximai.mes.pro.domain.vo.proWorkOrder.WorkorderPackage;
import com.ximai.mes.pro.service.impl.proWorkOrder.ProWorkorderServiceImpl;
import org.junit.Assert;
import org.junit.Test;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * @ Author: chicheng.li
 * @ Date  : 2024/3/28
 */
public class ProWorkorderServiceImplTest {

    @Test
    public void buildPackagePrintInfo() throws Exception {
        Method methods = ProWorkorderServiceImpl.class.getDeclaredMethod("buildPackagePrintInfo", BuildPackageParams2.class, List.class, List.class);
        methods.setAccessible(true);
        ProWorkorderServiceImpl proWorkorderService = new ProWorkorderServiceImpl();
        BuildPackageParams2 buildPackageParams2 = new BuildPackageParams2();
        List<ProWorkOrderSoSizeItem> sizeList = new ArrayList<ProWorkOrderSoSizeItem>();
        sizeList.add(new ProWorkOrderSoSizeItem() {{
            setQuantity(new BigDecimal("200"));
            setWorkorderSoSizeItemId(11L);
        }});
        sizeList.add(new ProWorkOrderSoSizeItem() {{
            setQuantity(new BigDecimal("170"));
            setWorkorderSoSizeItemId(12L);
        }});
        List<ProWorkOrderSoDirective> directiveList = new ArrayList<ProWorkOrderSoDirective>();
        directiveList.add(new ProWorkOrderSoDirective() {{
            setQuantity(new BigDecimal("370"));
            setLossNum(BigDecimal.ZERO);
            setWorkorderSoDirectiveId(21L);
        }});
        buildPackageParams2.setPackNum(50);
        buildPackageParams2.setQuantity(230);
        buildPackageParams2.setWorkorderCode("102321232123");
        buildPackageParams2.setSapItemCode("202321");
        //按SIZE
        List<WorkorderPackage> rst = (List<WorkorderPackage>) methods.invoke(proWorkorderService, buildPackageParams2, directiveList, sizeList);
        Assert.assertEquals(8, rst.size());
        Assert.assertEquals(20 + "", rst.get(7).getPackageNum() + "");
        Assert.assertEquals(11L + "", rst.get(0).getWorkorderSoSizeItemId() + "");
        Assert.assertEquals(12L + "", rst.get(4).getWorkorderSoSizeItemId() + "");

        //按SIZE包装-装箱标签（LOSS非独立包装）
        buildPackageParams2.setEncasementNum(500);
        rst = (List<WorkorderPackage>) methods.invoke(proWorkorderService, buildPackageParams2, directiveList, sizeList);
        Assert.assertEquals(9, rst.size());
        Assert.assertEquals(370 + "", rst.get(rst.size() - 1).getPackageNum() + "");
        Assert.assertEquals(8, rst.get(rst.size() - 1).getPackageList().size());

        //装箱数小于单SIZE数量
        buildPackageParams2.setEncasementNum(150);
        rst = (List<WorkorderPackage>) methods.invoke(proWorkorderService, buildPackageParams2, directiveList, sizeList);
        Assert.assertEquals(11, rst.size());
        Assert.assertEquals(70 + "", rst.get(rst.size() - 1).getPackageNum() + "");
        Assert.assertTrue(rst.get(rst.size() - 1).getQrcode().startsWith("BL"));
        Assert.assertTrue(rst.get(rst.size() - 1).getQrcode().endsWith("003"));
        Assert.assertEquals(2, rst.get(rst.size() - 1).getPackageList().size());
        Assert.assertTrue(rst.get(rst.size() - 1).getPackageList().get(0).getQrcode().endsWith("007"));
        Assert.assertTrue(rst.get(rst.size() - 1).getPackageList().get(1).getQrcode().endsWith("008"));

        //按SIZE包装-混合包装（LOSS非独立包装）
        buildPackageParams2.setMergePack(true);
        buildPackageParams2.setPackNum(Integer.MAX_VALUE);
        buildPackageParams2.setEncasementNum(null);
        rst = (List<WorkorderPackage>) methods.invoke(proWorkorderService, buildPackageParams2, directiveList, sizeList);
        Assert.assertEquals(1, rst.size(), 0);
        Assert.assertEquals(370, rst.get(0).getPackageNum(), 0);


        buildPackageParams2.setMergePack(true);
        buildPackageParams2.setPackNum(150);
        buildPackageParams2.setEncasementNum(300);
        rst = (List<WorkorderPackage>) methods.invoke(proWorkorderService, buildPackageParams2, directiveList, sizeList);
        Assert.assertEquals(5, rst.size(), 0);
        Assert.assertEquals(150, rst.get(0).getPackageNum(), 0);
        Assert.assertEquals(2, rst.get(1).getDistributes().size(), 0);
        Assert.assertEquals(50, rst.get(1).getDistributes().get(0).getPackageNum(), 0);
        Assert.assertEquals(100, rst.get(1).getDistributes().get(1).getPackageNum(), 0);


        buildPackageParams2.setPackNum(50);
        buildPackageParams2.setEncasementNum(150);
        buildPackageParams2.setMergePack(false);
        //按SIZE包装-LOSS独立包装
        //不存在LOSS数，包装标签数量不变
        buildPackageParams2.setEncasementNum(0);
        directiveList.get(0).setLossPack("Y");
        rst = (List<WorkorderPackage>) methods.invoke(proWorkorderService, buildPackageParams2, directiveList, sizeList);
        Assert.assertEquals(8, rst.size());
        //存在LOSS数，包装标签+1
        sizeList.get(0).setLossNum(new BigDecimal("5"));
        sizeList.get(1).setLossNum(new BigDecimal("3"));
        rst = (List<WorkorderPackage>) methods.invoke(proWorkorderService, buildPackageParams2, directiveList, sizeList);
        Assert.assertEquals(9, rst.size());
        Assert.assertEquals(45 + "", rst.get(3).getPackageNum() + "");
        Assert.assertEquals(17 + "", rst.get(rst.size() - 2).getPackageNum() + "");
        Assert.assertEquals(2, rst.get(rst.size() - 1).getDistributes().size());
        Assert.assertEquals(11L + "", rst.get(rst.size() - 1).getDistributes().get(0).getSizeId() + "");
        Assert.assertEquals(5 + "", rst.get(rst.size() - 1).getDistributes().get(0).getLossNum() + "");
        Assert.assertEquals(12L + "", rst.get(rst.size() - 1).getDistributes().get(1).getSizeId() + "");
        Assert.assertEquals(3 + "", rst.get(rst.size() - 1).getDistributes().get(1).getLossNum() + "");

        //按SIZE包装-装箱标签（LOSS独立包装）
        buildPackageParams2.setEncasementNum(500);
        rst = (List<WorkorderPackage>) methods.invoke(proWorkorderService, buildPackageParams2, directiveList, sizeList);
        Assert.assertEquals(10, rst.size());
        Assert.assertEquals(362 + "", rst.get(rst.size() - 1).getPackageNum() + "");
        Assert.assertEquals(8 + "", rst.get(rst.size() - 1).getLossNum() + "");

        buildPackageParams2.setEncasementNum(150);
        rst = (List<WorkorderPackage>) methods.invoke(proWorkorderService, buildPackageParams2, directiveList, sizeList);
        Assert.assertEquals(12, rst.size());
        Assert.assertTrue(rst.get(3).getQrcode().startsWith("BL"));
        Assert.assertEquals(8 + "", rst.get(rst.size() - 2).getLossNum() + "");
        Assert.assertEquals(0 + "", rst.get(rst.size() - 2).getPackageNum() + "");
        Assert.assertEquals(67 + "", rst.get(rst.size() - 1).getPackageNum() + "");
        Assert.assertEquals(8 + "", rst.get(rst.size() - 1).getLossNum() + "");
        Assert.assertTrue(rst.get(rst.size() - 1).getQrcode().startsWith("BL"));
        Assert.assertTrue(rst.get(rst.size() - 1).getQrcode().endsWith("003"));

    }

    //按指令分包装
    @Test
    public void buildPackagePrintInfoWithDirective() throws Exception {
        Method methods = ProWorkorderServiceImpl.class.getDeclaredMethod("buildPackagePrintInfo", BuildPackageParams2.class, List.class, List.class);
        methods.setAccessible(true);
        ProWorkorderServiceImpl proWorkorderService = new ProWorkorderServiceImpl();
        BuildPackageParams2 buildPackageParams2 = new BuildPackageParams2();
        List<ProWorkOrderSoDirective> directiveList = new ArrayList<ProWorkOrderSoDirective>();
        directiveList.add(new ProWorkOrderSoDirective() {{
            setQuantity(new BigDecimal("370"));
            setLossNum(BigDecimal.ZERO);
            setWorkorderSoDirectiveId(21L);
        }});
        directiveList.add(new ProWorkOrderSoDirective() {{
            setQuantity(new BigDecimal("300"));
            setLossNum(BigDecimal.ZERO);
            setWorkorderSoDirectiveId(22L);
        }});
        buildPackageParams2.setPackNum(100);
        buildPackageParams2.setQuantity(230);
        buildPackageParams2.setWorkorderCode("102321232123");
        buildPackageParams2.setSapItemCode("202321");

        List<WorkorderPackage> rst = (List<WorkorderPackage>) methods.invoke(proWorkorderService, buildPackageParams2, directiveList, null);
        Assert.assertEquals(7, rst.size());
        Assert.assertEquals(21L + "", rst.get(0).getWorkorderSoDirectiveId() + "");
        Assert.assertEquals(22L + "", rst.get(6).getWorkorderSoDirectiveId() + "");

        //装箱-非独立包装
        buildPackageParams2.setEncasementNum(300);
        rst = (List<WorkorderPackage>) methods.invoke(proWorkorderService, buildPackageParams2, directiveList, null);
        Assert.assertEquals(10, rst.size());
        Assert.assertTrue(rst.get(rst.size() - 2).getQrcode().startsWith("PL"));
        Assert.assertTrue(rst.get(rst.size() - 2).getQrcode().endsWith("007"));
        Assert.assertTrue(rst.get(rst.size() - 1).getQrcode().startsWith("BL"));
        Assert.assertTrue(rst.get(rst.size() - 1).getQrcode().endsWith("003"));
        Assert.assertEquals(100 + "", rst.get(rst.size() - 1).getPackageNum() + "");


        //按指令包装-LOSS独立包装
        //不存在LOSS数，包装标签数量不变
        buildPackageParams2.setEncasementNum(0);
        directiveList.get(0).setLossPack("Y");
        rst = (List<WorkorderPackage>) methods.invoke(proWorkorderService, buildPackageParams2, directiveList, null);
        Assert.assertEquals(7, rst.size());


        //其中一个指令存在LOSS数，包装标签+1
        directiveList.get(0).setLossNum(new BigDecimal("5"));
        directiveList.get(1).setLossNum(new BigDecimal("2"));
        rst = (List<WorkorderPackage>) methods.invoke(proWorkorderService, buildPackageParams2, directiveList, null);
        Assert.assertEquals(8, rst.size());
        Assert.assertEquals(65 + "", rst.get(3).getPackageNum() + "");
        Assert.assertEquals(5 + "", rst.get(4).getLossNum() + "");
        Assert.assertEquals(0 + "", rst.get(4).getPackageNum() + "");
        Assert.assertEquals(2 + "", rst.get(rst.size() - 1).getLossNum() + "");
        Assert.assertEquals(98 + "", rst.get(rst.size() - 1).getPackageNum() + "");

        //装箱-独立包装LOSS
        buildPackageParams2.setEncasementNum(300);
        rst = (List<WorkorderPackage>) methods.invoke(proWorkorderService, buildPackageParams2, directiveList, null);
        Assert.assertEquals(11, rst.size());
        Assert.assertEquals(98 + "", rst.get(rst.size() - 1).getPackageNum() + "");
        Assert.assertEquals(2 + "", rst.get(rst.size() - 1).getLossNum() + "");
        Assert.assertTrue(rst.get(8).getQrcode().startsWith("BL"));
        Assert.assertTrue(rst.get(8).getQrcode().endsWith("002"));
        Assert.assertEquals(2, rst.get(8).getDistributes().size());
        Assert.assertEquals(265 + "", rst.get(8).getPackageNum() + "");
        Assert.assertEquals(5 + "", rst.get(8).getLossNum() + "");
        Assert.assertEquals(1, rst.get(rst.size() - 1).getDistributes().size());
        Assert.assertEquals(2 + "", rst.get(rst.size() - 1).getDistributes().get(0).getLossNum() + "");
        Assert.assertEquals(8 + "", rst.get(0).getTotalCount() + "");
        Assert.assertEquals(1 + "", rst.get(0).getSheetCount() + "");
        Assert.assertEquals(8 + "", rst.get(rst.size() - 2).getTotalCount() + "");
        Assert.assertEquals(8 + "", rst.get(rst.size() - 2).getSheetCount() + "");
        Assert.assertEquals(3 + "", rst.get(rst.size() - 1).getTotalCount() + "");
        Assert.assertEquals(3 + "", rst.get(rst.size() - 1).getSheetCount() + "");
        Assert.assertTrue(rst.get(rst.size() - 1).getQrcode().startsWith("BL"));
        Assert.assertTrue(rst.get(rst.size() - 1).getQrcode().endsWith("003"));

        //按工单
        directiveList.clear();
        buildPackageParams2.setQuantity(430);
        buildPackageParams2.setEncasementNum(0);
        rst = (List<WorkorderPackage>) methods.invoke(proWorkorderService, buildPackageParams2, directiveList, null);
        Assert.assertEquals(5, rst.size());
        Assert.assertEquals(30 + "", rst.get(4).getPackageNum() + "");
    }

    @Test
    public void splitPackageBasic() throws Exception {
        ProWorkorderServiceImpl proWorkorderService = new ProWorkorderServiceImpl();
        Method methods = ProWorkorderServiceImpl.class.getDeclaredMethod("splitPackageBasic",
                List.class, boolean.class, boolean.class);
        methods.setAccessible(true);
        List<PackageBasicData> params = new ArrayList<PackageBasicData>();
        params.add(new PackageBasicData(31L, 3000, 1, false, 2000));
        params.add(new PackageBasicData(32L, 6000, 2, false, 2000));
        params.add(new PackageBasicData(33L, 7000, 3, false, 2000));
        //普通包装
        List<PackageBasicResult> rst = new ArrayList<PackageBasicResult>();
        rst = (List<PackageBasicResult>) methods.invoke(proWorkorderService, params, true, false);
        Assert.assertEquals(9, rst.size());
        Assert.assertEquals(999, rst.get(1).getPackageNum(), 0);
        Assert.assertEquals(1, rst.get(1).getLossNum(), 0);
        Assert.assertEquals(1998, rst.get(4).getPackageNum(), 0);
        Assert.assertEquals(2, rst.get(4).getLossNum(), 0);
        Assert.assertEquals(997, rst.get(8).getPackageNum(), 0);
        Assert.assertEquals(3, rst.get(8).getLossNum(), 0);
        //LOSS独立包装
        params.forEach(s -> s.setLossIndividuallyWrap(true));
        rst = (List<PackageBasicResult>) methods.invoke(proWorkorderService, params, true, false);
        Assert.assertEquals(10, rst.size());
        Assert.assertEquals(999, rst.get(1).getPackageNum(), 0);
        Assert.assertEquals(0, rst.get(1).getLossNum(), 0);
        Assert.assertEquals(3, rst.get(9).getDistributes().size(), 0);
        Assert.assertEquals(2, rst.get(9).getDistributes().get(1).getLossNum(), 0);

        //混合包装
        params.forEach(s -> s.setLossIndividuallyWrap(false));
        rst = (List<PackageBasicResult>) methods.invoke(proWorkorderService, params, true, true);
        Assert.assertEquals(8, rst.size());
        Assert.assertEquals(2, rst.get(1).getDistributes().size());
        Assert.assertEquals(1, rst.get(1).getLossNum(), 0);
        //LOSS独立包装
        params.forEach(s -> s.setLossIndividuallyWrap(true));
        rst = (List<PackageBasicResult>) methods.invoke(proWorkorderService, params, true, true);
        Assert.assertEquals(9, rst.size());
        Assert.assertEquals(2, rst.get(1).getDistributes().size());
        Assert.assertEquals(999, rst.get(1).getDistributes().get(0).getPackageNum(), 0);
        Assert.assertEquals(1001, rst.get(1).getDistributes().get(1).getPackageNum(), 0);
        Assert.assertEquals(3, rst.get(8).getDistributes().size(), 0);
        Assert.assertEquals(2, rst.get(8).getDistributes().get(1).getLossNum(), 0);

        //第二组数据
        params.clear();
        params.add(new PackageBasicData(31L, 2100, 200, false, 2000));
        params.add(new PackageBasicData(32L, 3200, 300, false, 2000));
        params.add(new PackageBasicData(33L, 4000, 400, false, 2000));

        //普通包装
        rst = (List<PackageBasicResult>) methods.invoke(proWorkorderService, params, true, false);
        Assert.assertEquals(6, rst.size());
        Assert.assertEquals(0, rst.get(0).getPackageNum(), 1900);
        Assert.assertEquals(100, rst.get(0).getLossNum(), 100);
        Assert.assertEquals(0, rst.get(1).getPackageNum(), 0);
        Assert.assertEquals(100, rst.get(1).getLossNum(), 0);
        Assert.assertEquals(900, rst.get(3).getPackageNum(), 0);
        Assert.assertEquals(300, rst.get(3).getLossNum(), 0);
        //LOSS独立包装
        params.forEach(s -> s.setLossIndividuallyWrap(true));
        rst = (List<PackageBasicResult>) methods.invoke(proWorkorderService, params, true, false);
        Assert.assertEquals(6, rst.size());
        Assert.assertEquals(1900, rst.get(0).getPackageNum(), 0);
        Assert.assertEquals(0, rst.get(0).getLossNum(), 0);
        Assert.assertEquals(2000, rst.get(1).getPackageNum(), 0);
        Assert.assertEquals(0, rst.get(1).getLossNum(), 0);
        Assert.assertEquals(0, rst.get(5).getPackageNum(), 0);
        Assert.assertEquals(900, rst.get(5).getLossNum(), 0);

        //混合包装
        params.forEach(s -> s.setLossIndividuallyWrap(false));
        rst = (List<PackageBasicResult>) methods.invoke(proWorkorderService, params, true, true);
        Assert.assertEquals(5, rst.size());
        Assert.assertEquals(1900, rst.get(0).getPackageNum(), 0);
        Assert.assertEquals(100, rst.get(0).getLossNum(), 0);
        Assert.assertEquals(2, rst.get(1).getDistributes().size(), 0);
        Assert.assertEquals(1900, rst.get(1).getDistributes().get(1).getPackageNum(), 0);
        Assert.assertEquals(100, rst.get(1).getDistributes().get(0).getLossNum(), 0);
        Assert.assertEquals(900, rst.get(4).getPackageNum(), 0);
        Assert.assertEquals(400, rst.get(4).getLossNum(), 0);
        //LOSS独立包装
        params.forEach(s -> s.setLossIndividuallyWrap(true));
        rst = (List<PackageBasicResult>) methods.invoke(proWorkorderService, params, true, true);
        Assert.assertEquals(6, rst.size());
        Assert.assertEquals(2000, rst.get(0).getPackageNum(), 0);
        Assert.assertEquals(0, rst.get(0).getLossNum(), 0);
        Assert.assertEquals(2, rst.get(0).getDistributes().size(), 0);
        Assert.assertEquals(1, rst.get(1).getDistributes().size(), 0);
        Assert.assertEquals(2000, rst.get(1).getPackageNum(), 0);
        Assert.assertEquals(0, rst.get(1).getDistributes().get(0).getLossNum(), 0);
        Assert.assertEquals(400, rst.get(4).getPackageNum(), 0);
        Assert.assertEquals(1, rst.get(4).getDistributes().size(), 0);
        Assert.assertEquals(3, rst.get(5).getDistributes().size(), 0);
        Assert.assertEquals(0, rst.get(5).getPackageNum(), 0);
        Assert.assertEquals(900, rst.get(5).getLossNum(), 0);

        //第三组数据
        params.clear();
        params.add(new PackageBasicData(31L, 1700, 10, false, 5000));
        params.add(new PackageBasicData(32L, 2200, 0, false, 5000));
        params.add(new PackageBasicData(33L, 2500, 20, false, 5000));
        params.add(new PackageBasicData(34L, 1700, 0, false, 5000));
        params.add(new PackageBasicData(35L, 1500, 0, false, 5000));
        params.add(new PackageBasicData(36L, 500, 0, false, 5000));
        //普通包装
        rst = (List<PackageBasicResult>) methods.invoke(proWorkorderService, params, true, false);
        Assert.assertEquals(6, rst.size());
        Assert.assertEquals(1690, rst.get(0).getPackageNum(), 0);
        Assert.assertEquals(10, rst.get(0).getLossNum(), 0);
        Assert.assertEquals(500, rst.get(5).getPackageNum(), 0);
        Assert.assertEquals(0, rst.get(5).getLossNum(), 0);
        //LOSS独立包装
        params.forEach(s -> s.setLossIndividuallyWrap(true));
        rst = (List<PackageBasicResult>) methods.invoke(proWorkorderService, params, true, false);
        Assert.assertEquals(7, rst.size());
        Assert.assertEquals(1690, rst.get(0).getPackageNum(), 0);
        Assert.assertEquals(0, rst.get(0).getLossNum(), 0);
        Assert.assertEquals(0, rst.get(6).getPackageNum(), 0);
        Assert.assertEquals(30, rst.get(6).getLossNum(), 0);
        Assert.assertEquals(2, rst.get(6).getDistributes().size(), 0);
        Assert.assertEquals(10, rst.get(6).getDistributes().get(0).getLossNum(), 0);

        //混合包装
        params.forEach(s -> s.setLossIndividuallyWrap(false));
        rst = (List<PackageBasicResult>) methods.invoke(proWorkorderService, params, true, true);
        Assert.assertEquals(3, rst.size());
        Assert.assertEquals(4990, rst.get(0).getPackageNum(), 0);
        Assert.assertEquals(10, rst.get(0).getLossNum(), 0);
        Assert.assertEquals(100, rst.get(2).getPackageNum(), 0);
        Assert.assertEquals(0, rst.get(2).getLossNum(), 0);
        //LOSS独立包装
        params.forEach(s -> s.setLossIndividuallyWrap(true));
        rst = (List<PackageBasicResult>) methods.invoke(proWorkorderService, params, true, true);
        Assert.assertEquals(4, rst.size());
        Assert.assertEquals(5000, rst.get(0).getPackageNum(), 0);
        Assert.assertEquals(0, rst.get(0).getLossNum(), 0);
        Assert.assertEquals(3, rst.get(0).getDistributes().size(), 0);
        Assert.assertEquals(1110, rst.get(0).getDistributes().get(2).getPackageNum(), 0);
        Assert.assertEquals(0, rst.get(3).getPackageNum(), 0);
        Assert.assertEquals(30, rst.get(3).getLossNum(), 0);
        Assert.assertEquals(2, rst.get(3).getDistributes().size(), 0);
        Assert.assertEquals(10, rst.get(3).getDistributes().get(0).getLossNum(), 0);

        //多指令报工(LOSS独立包装属性存在不一致)
        params.clear();
        params.add(new PackageBasicData(31L, 3000, 10, true, 3000));
        params.add(new PackageBasicData(32L, 4000, 15, true, 3000));
        params.add(new PackageBasicData(33L, 6000, 20, false, 2000));
        rst = (List<PackageBasicResult>) methods.invoke(proWorkorderService, params, false, false);
        Assert.assertEquals(8, rst.size());
        Assert.assertEquals(2990, rst.get(0).getPackageNum(), 0);
        Assert.assertEquals(0, rst.get(0).getLossNum(), 0);
        Assert.assertEquals(0, rst.get(1).getPackageNum(), 0);
        Assert.assertEquals(10, rst.get(1).getLossNum(), 0);

    }


    @Test
    public void buildBlPackage() throws Exception {
        Method methods = ProWorkorderServiceImpl.class.getDeclaredMethod("buildBlPackage", BuildPackageParams2.class, List.class);
        methods.setAccessible(true);
        ProWorkorderServiceImpl proWorkorderService = new ProWorkorderServiceImpl();
        BuildPackageParams2 buildPackageParams2 = new BuildPackageParams2();
        buildPackageParams2.setPackNum(70);
        buildPackageParams2.setEncasementNum(200);
        buildPackageParams2.setMergePack(true);
        buildPackageParams2.setWorkorderCode("102321232123");
        buildPackageParams2.setSapItemCode("202321");
        List<WorkorderPackage> rst = new ArrayList<WorkorderPackage>();
        rst.add(new WorkorderPackage() {{
            setQrcode("pl1");
            setPackageNum(70);
        }});
        rst.add(new WorkorderPackage() {{
            setWorkorderSoSizeItemId(1L);
            setQrcode("pl2");
            setPackageNum(70);
        }});
        rst.add(new WorkorderPackage() {{
            setWorkorderSoSizeItemId(1L);
            setQrcode("pl3");
            setPackageNum(70);
        }});
        rst.add(new WorkorderPackage() {{
            setWorkorderSoSizeItemId(1L);
            setQrcode("pl4");
            setPackageNum(70);
        }});
        rst.add(new WorkorderPackage() {{
            setQrcode("pl5");
            setPackageNum(70);
        }});
        rst.add(new WorkorderPackage() {{
            setWorkorderSoSizeItemId(1L);
            setQrcode("pl6");
            setPackageNum(70);
        }});
        rst.add(new WorkorderPackage() {{
            setWorkorderSoSizeItemId(1L);
            setQrcode("pl7");
            setPackageNum(70);
        }});
        rst.add(new WorkorderPackage() {{
            setWorkorderSoSizeItemId(1L);
            setQrcode("pl8");
            setPackageNum(32);
        }});
        rst.add(new WorkorderPackage() {{
            setQrcode("pl9");
            setLossNum(8);
        }});
        List<WorkorderPackage> tempList = new ArrayList<WorkorderPackage>();
        tempList.addAll(rst);
        methods.invoke(proWorkorderService, buildPackageParams2, tempList);
        Assert.assertEquals(tempList.size(), 13);
        Assert.assertEquals(tempList.get(tempList.size() - 1).getPackageNum(), 102, 0);
        Assert.assertEquals(tempList.get(tempList.size() - 1).getLossNum(), 8, 0);
        Assert.assertTrue(tempList.get(2).getQrcode().startsWith("BL"));
        Assert.assertEquals(tempList.get(2).getPackageList().size(), 2);
        Assert.assertTrue(tempList.get(5).getQrcode().startsWith("BL"));
        Assert.assertEquals(tempList.get(5).getPackageList().size(), 2);
        Assert.assertTrue(tempList.get(8).getQrcode().startsWith("BL"));
        Assert.assertEquals(tempList.get(8).getPackageList().size(), 2);
        Assert.assertTrue(tempList.get(tempList.size() - 1).getQrcode().startsWith("BL"));
        Assert.assertEquals(tempList.get(tempList.size() - 1).getPackageList().size(), 3);

        Assert.assertEquals(tempList.get(0).getBlGroup(), 1, 0);
        Assert.assertEquals(tempList.get(1).getBlGroup(), 1, 0);
        Assert.assertEquals(tempList.get(2).getBlGroup(), 1, 0);

        Assert.assertEquals(tempList.get(3).getBlGroup(), 2, 0);
        Assert.assertEquals(tempList.get(4).getBlGroup(), 2, 0);
        Assert.assertEquals(tempList.get(5).getBlGroup(), 2, 0);

        Assert.assertEquals(tempList.get(6).getBlGroup(), 3, 0);
        Assert.assertEquals(tempList.get(7).getBlGroup(), 3, 0);
        Assert.assertEquals(tempList.get(8).getBlGroup(), 3, 0);

        Assert.assertEquals(tempList.get(9).getBlGroup(), 4, 0);
        Assert.assertEquals(tempList.get(10).getBlGroup(), 4, 0);
        Assert.assertEquals(tempList.get(11).getBlGroup(), 4, 0);
        Assert.assertEquals(tempList.get(12).getBlGroup(), 4, 0);

        tempList.clear();
        tempList.addAll(rst);
        tempList.add(new WorkorderPackage() {{
            setQrcode("pl10");
            setLossNum(100);
        }});
        methods.invoke(proWorkorderService, buildPackageParams2, tempList);
        Assert.assertEquals(tempList.size(), 15);

        Assert.assertEquals(tempList.get(13).getBlGroup(), 5, 0);
        Assert.assertEquals(tempList.get(14).getBlGroup(), 5, 0);

        //测试2
        tempList.clear();
        tempList.addAll(rst);
        buildPackageParams2.setPackNum(70);
        buildPackageParams2.setEncasementNum(280);
        methods.invoke(proWorkorderService, buildPackageParams2, tempList);
        Assert.assertEquals(tempList.size(), 11);
        Assert.assertEquals(tempList.get(4).getPackageList().size(), 4);
        Assert.assertEquals(tempList.get(10).getPackageList().size(), 5);

        Assert.assertEquals(tempList.get(0).getBlGroup(), 1, 0);
        Assert.assertEquals(tempList.get(1).getBlGroup(), 1, 0);
        Assert.assertEquals(tempList.get(2).getBlGroup(), 1, 0);
        Assert.assertEquals(tempList.get(3).getBlGroup(), 1, 0);
        Assert.assertEquals(tempList.get(4).getBlGroup(), 1, 0);

        Assert.assertEquals(tempList.get(5).getBlGroup(), 2, 0);
        Assert.assertEquals(tempList.get(6).getBlGroup(), 2, 0);
        Assert.assertEquals(tempList.get(7).getBlGroup(), 2, 0);
        Assert.assertEquals(tempList.get(8).getBlGroup(), 2, 0);
        Assert.assertEquals(tempList.get(9).getBlGroup(), 2, 0);
        Assert.assertEquals(tempList.get(10).getBlGroup(), 2, 0);


    }
}
