package com.ximai.mes.tm.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.ximai.mes.md.vo.MdItemVo;
import com.ximai.mes.md.vo.MdWorkunitVo;
import com.ximai.mes.tm.domain.TmTool;
import com.ximai.mes.tm.domain.TmToolMachines;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;
import java.util.Map;

/**
 * 刀模版上下机Mapper接口
 *
 * @author generator
 * @date 2024-02-06
 */
public interface TmToolMachinesMapper extends BaseMapper<TmToolMachines> {
    /**
     * 查询刀模版上下机
     *
     * @param toolMachinesId 刀模版上下机主键
     * @return 刀模版上下机
     */
    TmToolMachines selectTmToolMachinesByToolMachinesId(Long toolMachinesId);


    List<TmToolMachines> selectOneByObj(Map<String, Object> obj);


    @Select("select ttm.*,ttrui.tool_id,ttrui.quantity,ttrui.item_id from tm_tool_machines ttm left join  tm_tool_request_use_item ttrui on ttm.tool_request_use_item_id = ttrui.tool_request_use_item_id   ${ew.customSqlSegment}")
    List<TmToolMachines> selectListJoinUseItemByQw(@Param("ew") QueryWrapper<TmToolMachines> ew);


    @Select("select t1.*,t2.item_id,COALESCE(tt.tool_code,t1.tool_code) from tm_tool_machines t1 left join tm_tool_request_use_item  t2 on t1.tool_request_use_item_id = t2.tool_request_use_item_id left join md_item mi on t2.item_id = mi.item_id left join tm_tool tt on t2.tool_id = tt.tool_id  ${ew.customSqlSegment}")
    List<TmToolMachines> selectListByQw(@Param("ew") QueryWrapper<TmToolMachines> ew);


    @Select("select t1.tool_machines_id, t1.tool_machines_code, t1.arrange_code, t1.workunit_id, t1.process_id, t1.workorder_id, t1.tool_request_use_id, " +
            "t1.tool_request_use_item_id, t1.task_workunit_id, t1.create_by, t1.create_time, t1.update_by, t1.update_time, t1.item_id, " +
            "t1.tool_name, t1.is_exist_tool, t1.task_id, t1.task_code, t1.task_name, t1.type, t1.warehouse, t1.up_date, t1.down_date, t1.workunit_code, t1.workunit_name, t1.warehouse_desc" +
            ",t2.item_id,COALESCE(tt.tool_code,t1.tool_code) tool_code  from tm_tool_machines t1 left join tm_tool_request_use_item  t2 on t1.tool_request_use_item_id = t2.tool_request_use_item_id left join md_item mi on t2.item_id = mi.item_id left join tm_tool tt on t2.tool_id = tt.tool_id  ${ew.customSqlSegment}")
    List<TmToolMachines> selectListByQws(@Param("ew") QueryWrapper<TmToolMachines> ew);

    @Select("select t1.*,t2.item_id from tm_tool_machines t1 left join md_item t2 on t1.item_id = t2.item_id    ${ew.customSqlSegment}")
    List<TmToolMachines> selectListByQwV2(@Param("ew") QueryWrapper<TmToolMachines> ew);


    @Select("select tt.* from   tm_tool_request_use_item t2 left join md_item mi on t2.item_id = mi.item_id left join tm_tool tt on t2.tool_id = tt.tool_id  ${ew.customSqlSegment}")
    List<TmTool> selectListToolByQw(@Param("ew") QueryWrapper<TmToolMachines> ew);


    /**
     * 查询刀模版上下机列表
     *
     * @param tmToolMachines 刀模版上下机
     * @return 刀模版上下机集合
     */
    List<TmToolMachines> selectTmToolMachinesList(TmToolMachines tmToolMachines);

    List<TmToolMachines> selectTmToolMachinesVoList(TmToolMachines tmToolMachines);

    /**
     * 新增刀模版上下机
     *
     * @param tmToolMachines 刀模版上下机
     * @return 结果
     */
    int insertTmToolMachines(TmToolMachines tmToolMachines);

    /**
     * 修改刀模版上下机
     *
     * @param tmToolMachines 刀模版上下机
     * @return 结果
     */
    int updateTmToolMachines(TmToolMachines tmToolMachines);

    /**
     * 删除刀模版上下机
     *
     * @param toolMachinesId 刀模版上下机主键
     * @return 结果
     */
    int deleteTmToolMachinesByToolMachinesId(Long toolMachinesId);

    /**
     * 批量删除刀模版上下机
     *
     * @param toolMachinesIds 需要删除的数据主键集合
     * @return 结果
     */
    int deleteTmToolMachinesByToolMachinesIds(Long[] toolMachinesIds);

    TmToolMachines selectOneBySn(TmToolMachines tmToolMachines);

    List<MdItemVo> selectUpTmToolRequestList(MdWorkunitVo mdWorkunit);
}
