package com.ximai.mes.tm.controller;

import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.core.page.TableDataInfo;
import com.ximai.common.enums.BusinessType;
import com.ximai.mes.tm.domain.TmToolWarehouse;
import com.ximai.mes.tm.service.ITmToolWarehouseService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 刀模版入库Controller
 *
 * @author generator
 * @date 2024-03-07
 */
@RestController
@RequestMapping("/md/warehouse")
public class TmToolWarehouseController extends BaseController {
    @Autowired
    private ITmToolWarehouseService tmToolWarehouseService;

    /**
     * 查询刀模版入库列表
     */
    @PreAuthorize("@ss.hasPermi('md:warehouse:list')")
    @GetMapping("/list")
    public TableDataInfo list(TmToolWarehouse tmToolWarehouse) {
        startPage();
        List<TmToolWarehouse> list = tmToolWarehouseService.selectTmToolWarehouseList(tmToolWarehouse);
        return getDataTable(list);
    }

    /**
     * 获取刀模版入库详细信息
     */
    @PreAuthorize("@ss.hasPermi('md:warehouse:query')")
    @GetMapping(value = "/{toolWarehouseId}")
    public AjaxResult getInfo(@PathVariable("toolWarehouseId") Long toolWarehouseId) {
        return AjaxResult.success(tmToolWarehouseService.selectTmToolWarehouseByToolWarehouseId(toolWarehouseId));
    }

    /**
     * 新增刀模版入库
     */
    @PreAuthorize("@ss.hasPermi('md:warehouse:add')")
    @Log(title = "刀模版入库", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TmToolWarehouse tmToolWarehouse) {
        return toAjax(tmToolWarehouseService.insertObj(tmToolWarehouse));
    }

    /**
     * 修改刀模版入库
     */
    @PreAuthorize("@ss.hasPermi('md:warehouse:edit')")
    @Log(title = "刀模版入库", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TmToolWarehouse tmToolWarehouse) {
        return toAjax(tmToolWarehouseService.updateTmToolWarehouse(tmToolWarehouse));
    }

    /**
     * 删除刀模版入库
     */
    @PreAuthorize("@ss.hasPermi('md:warehouse:remove')")
    @Log(title = "刀模版入库", businessType = BusinessType.DELETE)
    @DeleteMapping("/{toolWarehouseIds}")
    public AjaxResult remove(@PathVariable Long[] toolWarehouseIds) {
        return toAjax(tmToolWarehouseService.deleteTmToolWarehouseByToolWarehouseIds(toolWarehouseIds));
    }
}
