package com.ximai.mes.restful.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

@Data
public class PackageLinkInfo {

    @ApiModelProperty("生产工单号")
    String workorderNo;

    @ApiModelProperty("物料名称")
    String itemName;

    @ApiModelProperty("产成品物料号（SAP物料号）")
    String sapItemCode;

    @ApiModelProperty("指令号")
    String clientCmd;

    @ApiModelProperty("SIZE")
    String standardSize;

    @ApiModelProperty("总数量=数量+LOSS数量")
    Integer totalQuantity;

    @ApiModelProperty("数量")
    Integer quantity=0;

    @ApiModelProperty("LOSS数量")
    Integer lossNum=0;

    @ApiModelProperty("单位")
    String unitOfMeasure;

    @ApiModelProperty("工厂（固定值为1000 ）")
    String factory = "1000";

    @ApiModelProperty("PL编码")
    String qrcode;

    @ApiModelProperty("BL编码")
    String blQrcode;

    @ApiModelProperty("净重")
    BigDecimal netWeight;

    @ApiModelProperty("毛重")
    BigDecimal grossWeight;

    @ApiModelProperty("箱重")
    BigDecimal boxWeight;

    @ApiModelProperty("重量单位")
    String weightUnit="KG";

    @ApiModelProperty("检验人员")
    String checkBy;

    @ApiModelProperty("装箱创建人")
    String createBy;

    @ApiModelProperty("装箱创创日期")
    String createDate;

    @ApiModelProperty("装箱创建时间")
    String createTime;

    @ApiModelProperty("打印人")
    String printBy;

    @ApiModelProperty("打印日期")
    String printDate;

    @ApiModelProperty("打印时间")
    String printTime;

    @ApiModelProperty("装箱备注")
    String remark;

    @ApiModelProperty("装箱规格")
    private String packageStandard;

    @ApiModelProperty("体积")
    private String packVolume;

    @ApiModelProperty("打印模板规格")
    private String templateStandard;

    @ApiModelProperty("客户编号")
    private String clientCode;


}
