package com.ximai.mes.restful;

import com.alibaba.fastjson.JSON;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.utils.reflect.PackageUtil;
import com.ximai.framework.security.BasicAuth;
import com.ximai.mes.md.service.IMdItemService;
import com.ximai.mes.md.vo.ItemUpdateMesVo;
import io.swagger.annotations.ApiOperation;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.*;

/**
 * title: 产品物料接口
 * author:ZHT
 * date:2024/3/18
 * description:
 */
@RestController
@RequestMapping(value = "/api/v1/item")
public class ItemRestController {
    @Autowired
    private IMdItemService mdItemService;

    @ApiOperation(value = "ep产品物料创建")
    @BasicAuth
    @RequestMapping(value = "/itemCreate", method = RequestMethod.POST)
    public AjaxResult ItemCreate(@RequestBody String mdItemJson) {

        ItemUpdateMesVo mdItemVo = JSON.parseObject(mdItemJson).toJavaObject(ItemUpdateMesVo.class);


        int i = mdItemService.itemCreate(mdItemVo);
        if (i == 1) {
            return AjaxResult.success("新增成功");
        }
        if (i == 2) {
            return AjaxResult.success("修改成功");
        }
        if (i == 3) {
            return AjaxResult.success("删除成功");
        }

        return AjaxResult.success();
    }


}
