package com.ximai.mes.report.response;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.ximai.common.annotation.Excel;
import com.ximai.mes.pro.domain.ProFeedback;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;
@Data
public class FeedbackResponse extends ProFeedback {
    /**
     * 工单类型，项目号，订单号，
     * 生产工单，产品编码，产品名称，
     * 工序任务（报工表），工序名称，
     * 工作中心编码（报工表），工作中心名称，
     * 工作单元编码（报工表），工作单元名称，
     * 报工人员编码（报工表），报工人员名称，
     * 派工数量（报工表，派工数量为0不显示），
     * 报工数量，合格数量，不合格数量，
     * 不合格原因，标准工时（派工表），
     * 实际工时（报工表），
     * 计划完成时间（派工表），报工时间（报工表）
     */

    /**
     * 工单类型
     */
    @ApiModelProperty(name = "工单类型")
    private String workorderType;

    @ApiModelProperty("客户项目号")
    private String customerProjectNo;

    @ApiModelProperty("订单单号")
    private String orderCode;

    @ApiModelProperty(name = "工单编码")
    private String workorderCode;

    @ApiModelProperty(name = "工单名称")
    private String workorderName;
    /**
     * 产品编号
     */
    @ApiModelProperty(name = "产品编号")
    private String productCode;

    /**
     * 产品名称
     */
    @ApiModelProperty(name = "产品名称")
    private String productName;

    /**
     * 任务编号
     */
    @ApiModelProperty(name = "工序任务号")
    private String taskCode;



    /**
     * 工序名称
     */
    @ApiModelProperty(name = "工序编码")
    private String processCode;
    /**
     * 工序名称
     */
    @ApiModelProperty(name = "工序名称")
    private String processName;


    /**
     * 工作中心编号
     */
    @ApiModelProperty(name = "工作中心编号")
    private String workstationCode;

    /**
     * 工作中心名称
     */
    @ApiModelProperty(name = "工作中心名称")
    private String workstationName;


    /**
     *
     */
    @ApiModelProperty("工作单元ID")
    private Long workunitId;

    /**
     *
     */
    @ApiModelProperty("工作单元编码")
    private String workunitCode;

    @ApiModelProperty("工作单元名称")
    private String workunitName;

    @ApiModelProperty("报工人员")
    private String userName;

    @ApiModelProperty("报工人员名称")
    private String nickName;

    /**
     * 排产数量
     */
    @ApiModelProperty(name = "派工数量")
    private BigDecimal quantity;


    /**
     * 本次报工数量
     */
    @ApiModelProperty(name = "本次报工数量")
    private BigDecimal quantityFeedback;

    /**
     * 合格品数量
     */
    @ApiModelProperty(name = "合格品数量")
    private BigDecimal quantityQualify;

    /**
     * 不良品数量
     */
    @ApiModelProperty(name = "不良品数量")
    private BigDecimal quantityUnqualify;

    /** 异常原因 */
    @ApiModelProperty(name = "异常原因")
    private String abnormalReason;

    @ApiModelProperty("标准工时")
    private BigDecimal stdWorkingTime;

    @ApiModelProperty("实际工时")
    private String machineTime;

    /**
     * 预计结束时间
     */
    @ApiModelProperty("计划结束时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date scheduleEndDate;
    /**
     * 报工时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(name = "报工时间")
    private Date feedbackTime;


    @ApiModelProperty("良率")
    private String qualificationRate;
    @ApiModelProperty("车间编号")
    private String workshopCode;

    @ApiModelProperty("车间名称")
    private String workshopName;
}
