package com.ximai.mes.qc.mapper;

import com.ximai.mes.qc.domain.QcTemplateProduct;

import java.util.List;

/**
 * 检测模板-产品Mapper接口
 *
 * @date 2022-05-18
 */
public interface QcTemplateProductMapper {
    /**
     * 查询检测模板-产品
     *
     * @param id 检测模板-产品主键
     * @return 检测模板-产品
     */
    QcTemplateProduct selectQcTemplateProductByRecordId(Long id);

    /**
     * 查询检测模板-产品列表
     *
     * @param qcTemplateProduct 检测模板-产品
     * @return 检测模板-产品集合
     */
    List<QcTemplateProduct> selectQcTemplateProductList(QcTemplateProduct qcTemplateProduct);

    QcTemplateProduct checkProductUnique(QcTemplateProduct qcTemplateProduct);


    /**
     * 新增检测模板-产品
     *
     * @param qcTemplateProduct 检测模板-产品
     * @return 结果
     */
    int insertQcTemplateProduct(QcTemplateProduct qcTemplateProduct);

    /**
     * 修改检测模板-产品
     *
     * @param qcTemplateProduct 检测模板-产品
     * @return 结果
     */
    int updateQcTemplateProduct(QcTemplateProduct qcTemplateProduct);

    /**
     * 删除检测模板-产品
     *
     * @param id 检测模板-产品主键
     * @return 结果
     */
    int deleteQcTemplateProductByRecordId(Long id);

    /**
     * 批量删除检测模板-产品
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    int deleteQcTemplateProductByRecordIds(Long[] ids);

    int deleteByTemplateId(Long templateId);

}
