package com.ximai.mes.qc.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ximai.mes.qc.domain.QcIpqc;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * 过程检验单Mapper接口
 *
 * @date 2022-08-29
 */
public interface QcIpqcMapper {
    /**
     * 查询过程检验单
     *
     * @param ipqcId 过程检验单主键
     * @return 过程检验单
     */
    QcIpqc selectQcIpqcByIpqcId(Long ipqcId);

    /**
     * 查询过程检验单列表
     *
     * @param qcIpqc 过程检验单
     * @return 过程检验单集合
     */
    List<QcIpqc> selectQcIpqcList(QcIpqc qcIpqc);

    /**
     * 验证检测编码是否唯一
     *
     * @param qcIpqc
     * @return
     */
    QcIpqc checkIpqcCodeUnique(QcIpqc qcIpqc);


    /**
     * 根据当前传递的过程检验单，查询更多工艺相关信息
     *
     * @param qcIpqc
     * @return
     */
    @Select("SELECT\n" +
            "        pw.workorder_id,\n" +
            "        pw.workorder_code,\n" +
            "        pw.workorder_name,\n" +
            "        pp.process_id,\n" +
            "        pp.process_code,\n" +
            "        pp.process_name,\n" +
            "        mw.workstation_id,\n" +
            "        mw.workstation_code,\n" +
            "        mw.workstation_name\n" +
            "        FROM\n" +
            "        pro_work_order_process pwp\n" +
            "            left join pro_workorder pw on  pw.workorder_id = pwp.workorder_id\n" +
            "        LEFT JOIN pro_process pp ON pwp.process_id = pp.process_id\n" +
            "        LEFT JOIN md_workstation mw ON mw.workstation_id = pwp.workstation_id ${ew.customSqlSegment}")
    List<QcIpqc> selectProcessInfoByQw(@Param("ew") QueryWrapper<QcIpqc> query);

    /**
     * 新增过程检验单
     *
     * @param qcIpqc 过程检验单
     * @return 结果
     */
    int insertQcIpqc(QcIpqc qcIpqc);

    /**
     * 修改过程检验单
     *
     * @param qcIpqc 过程检验单
     * @return 结果
     */
    int updateQcIpqc(QcIpqc qcIpqc);

    /**
     * 根据缺陷记录更新头上的缺陷数量和缺陷率
     *
     * @param ipqcId
     * @return
     */
    int updateCrMajMinQuaAndRate(Long ipqcId);

    /**
     * 删除过程检验单
     *
     * @param ipqcId 过程检验单主键
     * @return 结果
     */
    int deleteQcIpqcByIpqcId(Long ipqcId);

    /**
     * 批量删除过程检验单
     *
     * @param ipqcIds 需要删除的数据主键集合
     * @return 结果
     */
    int deleteQcIpqcByIpqcIds(Long[] ipqcIds);

    @Select(value = "select t1.* from cal_plan_workunit t1\n" +
            "${ew.customSqlSegment}")
    List<QcIpqc> selectListByQw(@Param("ew") QueryWrapper<QcIpqc> query);

    @Select(value =
            "select t1.* from qc_ipqc t1 inner join md_workstation_worker t2 on t1.workstation_id = t2.workstation_id left join pro_task t3 on t1.task_id = t3.task_id ${ew.customSqlSegment}")
    List<QcIpqc> selectWorkStationPermListByQw(@Param("ew") QueryWrapper<QcIpqc> query);


    @Select(value =
            "select t1.* from qc_ipqc t1  inner join pro_task_workunit t2 on t2.task_id = t1.task_id inner join md_workunit_worker t3 on t3.workunit_id =t2.workunit_id ${ew.customSqlSegment}")
    List<QcIpqc> selectWorkunitPermListByQw(@Param("ew") QueryWrapper<QcIpqc> query);
}
