package com.ximai.mes.qc.mapper;

import java.util.List;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.ximai.mes.qc.domain.QcAbnormalReport;
import com.ximai.mes.qc.dto.QcAbnormalReportDto;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

/**
 * 车间异常单Mapper接口
 *
 * @author generator
 * @date 2024-02-20
 */
public interface QcAbnormalReportMapper extends BaseMapper<QcAbnormalReport>
{
    /**
     * 查询车间异常单
     *
     * @param abnormalReportId 车间异常单主键
     * @return 车间异常单
     */
    public QcAbnormalReport selectQcAbnormalReportByAbnormalReportId(Long abnormalReportId);

    /**
     * 查询车间异常单列表
     *
     * @param qcAbnormalReport 车间异常单
     * @return 车间异常单集合
     */
    public List<QcAbnormalReport> selectQcAbnormalReportList(QcAbnormalReport qcAbnormalReport);

    /**
     * 查询车间异常单列表
     *
     * @param query 车间异常单
     * @return 车间异常单集合
     */

    @Select(value = "select t1.* from qc_abnormal_report t1\n" +
            "${ew.customSqlSegment}")
    public List<QcAbnormalReportDto> selectQcAbnormalReportDtoList(@Param("ew") QueryWrapper<QcAbnormalReport> query);

    /**
     * 新增车间异常单
     *
     * @param qcAbnormalReport 车间异常单
     * @return 结果
     */
    public int insertQcAbnormalReport(QcAbnormalReport qcAbnormalReport);

    /**
     * 修改车间异常单
     *
     * @param qcAbnormalReport 车间异常单
     * @return 结果
     */
    public int updateQcAbnormalReport(QcAbnormalReport qcAbnormalReport);

    /**
     * 删除车间异常单
     *
     * @param abnormalReportId 车间异常单主键
     * @return 结果
     */
    public int deleteQcAbnormalReportByAbnormalReportId(Long abnormalReportId);

    /**
     * 批量删除车间异常单
     *
     * @param abnormalReportIds 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteQcAbnormalReportByAbnormalReportIds(Long[] abnormalReportIds);

    /**
     * 查询所有未关闭异常设备数量
     *
     * @return 结果
     */
    @Select(value = "select count(1) from (select task_workunit_id from qc_abnormal_report\n" +
            "where abnormal_status in ('NOT', 'SUBMIT') and abnormal_type = 'DEVI' group by task_workunit_id) t")
    public int countAbnormalEquip();
}
