package com.ximai.mes.pro.service.impl.task;

import java.util.List;
import com.ximai.common.utils.data.DateUtils;
import com.ximai.common.utils.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ximai.mes.pro.mapper.task.ProTaskWorkunitOpRecordMapper;
import com.ximai.mes.pro.domain.task.ProTaskWorkunitOpRecord;
import com.ximai.mes.pro.service.task.IProTaskWorkunitOpRecordService;

/**
 * 任务派工修改记录Service业务层处理
 *
 * @author generator
 * @date 2024-08-13
 */
@Service
public class ProTaskWorkunitOpRecordServiceImpl implements IProTaskWorkunitOpRecordService
{
    @Autowired
    private ProTaskWorkunitOpRecordMapper proTaskWorkunitOpRecordMapper;

    /**
     * 查询任务派工修改记录
     *
     * @param id 任务派工修改记录主键
     * @return 任务派工修改记录
     */
    @Override
    public ProTaskWorkunitOpRecord selectProTaskWorkunitOpRecordById(Long id)
    {
        return proTaskWorkunitOpRecordMapper.selectProTaskWorkunitOpRecordById(id);
    }

    /**
     * 查询任务派工修改记录列表
     *
     * @param proTaskWorkunitOpRecord 任务派工修改记录
     * @return 任务派工修改记录
     */
    @Override
    public List<ProTaskWorkunitOpRecord> selectProTaskWorkunitOpRecordList(ProTaskWorkunitOpRecord proTaskWorkunitOpRecord)
    {
        return proTaskWorkunitOpRecordMapper.selectProTaskWorkunitOpRecordList(proTaskWorkunitOpRecord);
    }

    /**
     * 新增任务派工修改记录
     *
     * @param proTaskWorkunitOpRecord 任务派工修改记录
     * @return 结果
     */
    @Override
    public int insertProTaskWorkunitOpRecord(ProTaskWorkunitOpRecord proTaskWorkunitOpRecord)
    {
        proTaskWorkunitOpRecord.setCreateBy(SecurityUtils.getUsername());
        proTaskWorkunitOpRecord.setCreateTime(DateUtils.getNowDate());
        return proTaskWorkunitOpRecordMapper.insertProTaskWorkunitOpRecord(proTaskWorkunitOpRecord);
    }

    /**
     * 修改任务派工修改记录
     *
     * @param proTaskWorkunitOpRecord 任务派工修改记录
     * @return 结果
     */
    @Override
    public int updateProTaskWorkunitOpRecord(ProTaskWorkunitOpRecord proTaskWorkunitOpRecord)
    {
        return proTaskWorkunitOpRecordMapper.updateProTaskWorkunitOpRecord(proTaskWorkunitOpRecord);
    }

    /**
     * 批量删除任务派工修改记录
     *
     * @param ids 需要删除的任务派工修改记录主键
     * @return 结果
     */
    @Override
    public int deleteProTaskWorkunitOpRecordByIds(Long[] ids)
    {
        return proTaskWorkunitOpRecordMapper.deleteProTaskWorkunitOpRecordByIds(ids);
    }

    /**
     * 删除任务派工修改记录信息
     *
     * @param id 任务派工修改记录主键
     * @return 结果
     */
    @Override
    public int deleteProTaskWorkunitOpRecordById(Long id)
    {
        return proTaskWorkunitOpRecordMapper.deleteProTaskWorkunitOpRecordById(id);
    }
}
