package com.ximai.mes.pro.service.impl.productionMake;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ximai.mes.pro.mapper.productionMake.ProProductionMakeProcessItemMapper;
import com.ximai.mes.pro.domain.productionMake.ProProductionMakeProcessItem;
import com.ximai.mes.pro.service.productionMake.IProProductionMakeProcessItemService;

/**
 * 量产制作工序物料Service业务层处理
 *
 * @author chicheng.li
 * @date 2024-01-23
 */
@Service
public class ProProductionMakeProcessItemServiceImpl implements IProProductionMakeProcessItemService
{
    @Autowired
    private ProProductionMakeProcessItemMapper proProductionMakeProcessItemMapper;

    /**
     * 查询量产制作工序物料
     *
     * @param productionMakeProcessItemId 量产制作工序物料主键
     * @return 量产制作工序物料
     */
    @Override
    public ProProductionMakeProcessItem selectProProductionMakeProcessItemByProductionMakeProcessItemId(Long productionMakeProcessItemId)
    {
        return proProductionMakeProcessItemMapper.selectProProductionMakeProcessItemByProductionMakeProcessItemId(productionMakeProcessItemId);
    }

    /**
     * 查询量产制作工序物料列表
     *
     * @param proProductionMakeProcessItem 量产制作工序物料
     * @return 量产制作工序物料
     */
    @Override
    public List<ProProductionMakeProcessItem> selectProProductionMakeProcessItemList(ProProductionMakeProcessItem proProductionMakeProcessItem)
    {
        return proProductionMakeProcessItemMapper.selectProProductionMakeProcessItemList(proProductionMakeProcessItem);
    }

    /**
     * 新增量产制作工序物料
     *
     * @param proProductionMakeProcessItem 量产制作工序物料
     * @return 结果
     */
    @Override
    public int insertProProductionMakeProcessItem(ProProductionMakeProcessItem proProductionMakeProcessItem)
    {
        return proProductionMakeProcessItemMapper.insertProProductionMakeProcessItem(proProductionMakeProcessItem);
    }

    /**
     * 修改量产制作工序物料
     *
     * @param proProductionMakeProcessItem 量产制作工序物料
     * @return 结果
     */
    @Override
    public int updateProProductionMakeProcessItem(ProProductionMakeProcessItem proProductionMakeProcessItem)
    {
        return proProductionMakeProcessItemMapper.updateProProductionMakeProcessItem(proProductionMakeProcessItem);
    }

    /**
     * 批量删除量产制作工序物料
     *
     * @param productionMakeProcessItemIds 需要删除的量产制作工序物料主键
     * @return 结果
     */
    @Override
    public int deleteProProductionMakeProcessItemByProductionMakeProcessItemIds(Long[] productionMakeProcessItemIds)
    {
        return proProductionMakeProcessItemMapper.deleteProProductionMakeProcessItemByProductionMakeProcessItemIds(productionMakeProcessItemIds);
    }

    /**
     * 删除量产制作工序物料信息
     *
     * @param productionMakeProcessItemId 量产制作工序物料主键
     * @return 结果
     */
    @Override
    public int deleteProProductionMakeProcessItemByProductionMakeProcessItemId(Long productionMakeProcessItemId)
    {
        return proProductionMakeProcessItemMapper.deleteProProductionMakeProcessItemByProductionMakeProcessItemId(productionMakeProcessItemId);
    }
}
