package com.ximai.mes.pro.service.impl;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ximai.mes.pro.mapper.ProProductionLogMapper;
import com.ximai.mes.pro.domain.ProProductionLog;
import com.ximai.mes.pro.service.IProProductionLogService;

/**
 * 机器生产记录Service业务层处理
 *
 * @author yinjinlu
 * @date 2024-01-20
 */
@Service
public class ProProductionLogServiceImpl implements IProProductionLogService
{
    @Autowired
    private ProProductionLogMapper proProductionLogMapper;

    /**
     * 查询机器生产记录
     *
     * @param recordId 机器生产记录主键
     * @return 机器生产记录
     */
    @Override
    public ProProductionLog selectProProductionLogByRecordId(Long recordId)
    {
        return proProductionLogMapper.selectProProductionLogByRecordId(recordId);
    }

    /**
     * 查询机器生产记录列表
     *
     * @param proProductionLog 机器生产记录
     * @return 机器生产记录
     */
    @Override
    public List<ProProductionLog> selectProProductionLogList(ProProductionLog proProductionLog)
    {
        return proProductionLogMapper.selectProProductionLogList(proProductionLog);
    }

    /**
     * 新增机器生产记录
     *
     * @param proProductionLog 机器生产记录
     * @return 结果
     */
    @Override
    public int insertProProductionLog(ProProductionLog proProductionLog)
    {
        return proProductionLogMapper.insertProProductionLog(proProductionLog);
    }

    /**
     * 修改机器生产记录
     *
     * @param proProductionLog 机器生产记录
     * @return 结果
     */
    @Override
    public int updateProProductionLog(ProProductionLog proProductionLog)
    {
        return proProductionLogMapper.updateProProductionLog(proProductionLog);
    }

    /**
     * 批量删除机器生产记录
     *
     * @param recordIds 需要删除的机器生产记录主键
     * @return 结果
     */
    @Override
    public int deleteProProductionLogByRecordIds(Long[] recordIds)
    {
        return proProductionLogMapper.deleteProProductionLogByRecordIds(recordIds);
    }

    /**
     * 删除机器生产记录信息
     *
     * @param recordId 机器生产记录主键
     * @return 结果
     */
    @Override
    public int deleteProProductionLogByRecordId(Long recordId)
    {
        return proProductionLogMapper.deleteProProductionLogByRecordId(recordId);
    }
}
