package com.ximai.mes.pro.service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ximai.mes.pro.domain.ProScheduleSetupRuleVal;
import com.ximai.mes.pro.domain.proWorkOrder.ProWorkorder;

import java.util.List;
import java.util.Map;

/**
 * 排产换型属性值信息Service接口
 *
 * @author generator
 * @date 2024-04-01
 */
public interface IProScheduleSetupRuleValService {
    /**
     * 查询排产换型属性值信息
     *
     * @param ruleValId 排产换型属性值信息主键
     * @return 排产换型属性值信息
     */
    ProScheduleSetupRuleVal selectProScheduleSetupRuleValByRuleValId(Long ruleValId);

    /**
     * 查询排产换型属性值信息列表
     *
     * @param proScheduleSetupRuleVal 排产换型属性值信息
     * @return 排产换型属性值信息集合
     */
    List<ProScheduleSetupRuleVal> selectProScheduleSetupRuleValList(ProScheduleSetupRuleVal proScheduleSetupRuleVal);

    /**
     * 新增排产换型属性值信息
     *
     * @param proScheduleSetupRuleVal 排产换型属性值信息
     * @return 结果
     */
    int insertProScheduleSetupRuleVal(ProScheduleSetupRuleVal proScheduleSetupRuleVal);

    /**
     * 修改排产换型属性值信息
     *
     * @param proScheduleSetupRuleVal 排产换型属性值信息
     * @return 结果
     */
    int updateProScheduleSetupRuleVal(ProScheduleSetupRuleVal proScheduleSetupRuleVal);

    /**
     * 批量删除排产换型属性值信息
     *
     * @param ruleValIds 需要删除的排产换型属性值信息主键集合
     * @return 结果
     */
    int deleteProScheduleSetupRuleValByRuleValIds(Long[] ruleValIds);

    /**
     * 删除排产换型属性值信息信息
     *
     * @param ruleValId 排产换型属性值信息主键
     * @return 结果
     */
    int deleteProScheduleSetupRuleValByRuleValId(Long ruleValId);

    /**
     * 查询换型规则属性唯一值列表，按工单ID+工序分组数据
     *
     * @param query 工单编排规则属性唯一值
     * @return 工单编排规则属性唯一值集合
     */
    Map<String, Map<String, Object>> selectScheduleSetupRuleValGroup(QueryWrapper<ProScheduleSetupRuleVal> query);

    /**
     * 新增排产换型属性值信息
     *
     * @param proWorkorder 工单
     * @return 结果
     */
    void insertProScheduleSetupRuleVal(ProWorkorder proWorkorder);

    /**
     * 根据工单删除数据
     *
     * @param workorderId
     */
    void deleteScheduleSetupRuleVal(Long workorderId);
}
