package com.ximai.mes.pro.service;

import java.util.List;
import com.ximai.mes.pro.domain.ProProductionLog;

/**
 * 机器生产记录Service接口
 *
 * @author yinjinlu
 * @date 2024-01-20
 */
public interface IProProductionLogService
{
    /**
     * 查询机器生产记录
     *
     * @param recordId 机器生产记录主键
     * @return 机器生产记录
     */
    public ProProductionLog selectProProductionLogByRecordId(Long recordId);

    /**
     * 查询机器生产记录列表
     *
     * @param proProductionLog 机器生产记录
     * @return 机器生产记录集合
     */
    public List<ProProductionLog> selectProProductionLogList(ProProductionLog proProductionLog);

    /**
     * 新增机器生产记录
     *
     * @param proProductionLog 机器生产记录
     * @return 结果
     */
    public int insertProProductionLog(ProProductionLog proProductionLog);

    /**
     * 修改机器生产记录
     *
     * @param proProductionLog 机器生产记录
     * @return 结果
     */
    public int updateProProductionLog(ProProductionLog proProductionLog);

    /**
     * 批量删除机器生产记录
     *
     * @param recordIds 需要删除的机器生产记录主键集合
     * @return 结果
     */
    public int deleteProProductionLogByRecordIds(Long[] recordIds);

    /**
     * 删除机器生产记录信息
     *
     * @param recordId 机器生产记录主键
     * @return 结果
     */
    public int deleteProProductionLogByRecordId(Long recordId);
}
