package com.ximai.mes.pro.service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ximai.mes.pro.domain.ProFeedback;
import com.ximai.mes.pro.domain.task.ProTask;
import com.ximai.mes.pro.domain.task.ProTaskAssistProcess;
import com.ximai.mes.pro.domain.vo.ProFeedbackSplitInfo;
import com.ximai.mes.pro.domain.vo.ProFeedbackVo;
import com.ximai.mes.pro.domain.vo.ProPackagePrintResult;
import com.ximai.mes.pro.domain.vo.feedbackTaskVo;
import com.ximai.mes.pro.domain.vo.task.FeedbackValidateSerialNoParams;
import com.ximai.mes.pro.dto.ProFeedbackDto;

import java.util.LinkedHashMap;
import java.util.List;

/**
 * 生产报工记录Service接口
 *
 * @date 2022-07-10
 */
public interface IProFeedbackService {
    /**
     * 查询生产报工记录
     *
     * @param recordId 生产报工记录主键
     * @return 生产报工记录
     */
    ProFeedback selectProFeedbackByRecordId(Long recordId);

    /**
     * 查询生产报工记录列表
     *
     * @param proFeedback 生产报工记录
     * @return 生产报工记录集合
     */
    List<ProFeedback> selectProFeedbackList(ProFeedback proFeedback);

    /**
     * 查询生产报工记录列表
     *
     * @param query 生产报工记录
     * @return 生产报工记录集合
     */
    List<ProFeedbackVo> queryProFeedbackListJoinTaskWorkUnit(QueryWrapper<ProFeedback> query);
    /**
     * 查询生产报工记录列表
     *
     * @param query 生产报工记录
     * @return 生产报工记录集合
     */
    List<ProFeedbackDto> queryProFeedbackDtoJoinTaskWorkUnit(QueryWrapper<ProFeedback> query);

    /**
     * 查询生产报工记录列表
     *
     * @param query 生产报工记录
     * @return 生产报工记录集合
     */
    List<ProFeedback> selectProFeedbackList(QueryWrapper<ProFeedback> query);

    /**
     * 验证序列号报工
     * @param validateSerialNoParams
     */
    boolean validateSerialNo(FeedbackValidateSerialNoParams validateSerialNoParams);

    /**
     * 新增生产报工记录
     *
     * @param proFeedback 生产报工记录
     * @return 结果
     */
    int insertProFeedback(ProFeedback proFeedback);

    /**
     * 修改生产报工记录
     *
     * @param proFeedback 生产报工记录
     * @return 结果
     */
    int updateProFeedback(ProFeedback proFeedback);

    /**
     * 批量删除生产报工记录
     *
     * @param recordIds 需要删除的生产报工记录主键集合
     * @return 结果
     */
    int deleteProFeedbackByRecordIds(Long[] recordIds);

    /**
     * 删除生产报工记录信息
     *
     * @param recordId 生产报工记录主键
     * @return 结果
     */
    int deleteProFeedbackByRecordId(Long recordId);


    /**
     * 温志超修改 ：合格和非合格数量都将计入数量中
     * @param proFeedback
     * @return
     */
    Double selectQuantityQualifySum(ProFeedback proFeedback);

    LinkedHashMap<String, ProFeedbackSplitInfo> taskFeedback(ProTask proTask, ProFeedback mainFeedBack);


    int updateObj(ProFeedback proFeedback);

    int syncSap(Long recordId);

    int insertObj(ProFeedback proFeedback);

    List<feedbackTaskVo> selectProFeedbackreport(feedbackTaskVo feedbackTaskVo);

    List<ProFeedback> selectListByTwId(Long taskWorkunitId);
}
