package com.ximai.mes.pro.service;

import java.util.List;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ximai.mes.pro.domain.ProAllocationMaterial;
import com.ximai.mes.pro.domain.task.ProTaskWorkunit;
import com.ximai.mes.pro.domain.vo.ProAllocationMaterialVo;

/**
 * 调拨料申请Service接口
 * 
 * @author generator
 * @date 2024-05-14
 */
public interface IProAllocationMaterialService 
{
    /**
     * 查询调拨料申请
     * 
     * @param allocationMaterialId 调拨料申请主键
     * @return 调拨料申请
     */
    public ProAllocationMaterial selectProAllocationMaterialByAllocationMaterialId(Long allocationMaterialId);

    /**
     * 查询调拨料申请列表
     *
     * @param proAllocationMaterial 调拨料申请
     * @return 调拨料申请集合
     */
    public List<ProAllocationMaterial> selectProAllocationMaterialList(ProAllocationMaterial proAllocationMaterial);

    /**
     * 查询调拨料申请列表
     *
     * @param query 调拨料申请
     * @return 调拨料申请集合
     */
    public List<ProAllocationMaterial> selectProAllocationMaterialList(QueryWrapper<ProAllocationMaterial> query);

    /**
     * 自动新增调拨料申请
     * 
     * @param proAllocationMaterial 调拨料申请
     * @return 结果
     */
    public int insertProAllocationMaterial(ProAllocationMaterial proAllocationMaterial);



    /**
     * 手动新增调拨料申请
     *
     * @param proAllocationMaterialVo 调拨料申请
     * @return 结果
     */
    public int insertProAllocationMaterialManual(ProAllocationMaterialVo proAllocationMaterialVo);

    /**
     * 修改调拨料申请
     *
     * @param proAllocationMaterial 调拨料申请
     * @return 结果
     */
    public int updateProAllocationMaterial(ProAllocationMaterial proAllocationMaterial);

    /**
     * 修改调拨料申请
     *
     * @param taskWorkunit 任务派工
     * @return 结果
     */
    public void updateProAllocationMaterialByTaskWorkunit(ProTaskWorkunit taskWorkunit);

    /**
     * 批量删除调拨料申请
     * 
     * @param allocationMaterialIds 需要删除的调拨料申请主键集合
     * @return 结果
     */
    public int deleteProAllocationMaterialByAllocationMaterialIds(Long[] allocationMaterialIds);

    /**
     * 删除调拨料申请信息
     * 
     * @param allocationMaterialId 调拨料申请主键
     * @return 结果
     */
    public int deleteProAllocationMaterialByAllocationMaterialId(Long allocationMaterialId);

    void insertProAllocationMaterialList(List<ProAllocationMaterial> proAllocationMaterials);
}
