package com.ximai.mes.pro.schedule;

import lombok.Data;

import java.math.BigDecimal;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

@Data
public class Job {

    public Job(String id, Duration producedDeliveryTime)
    {
        this.id = id;
        this.producedDeliveryTime = producedDeliveryTime;
        this.lmtStartedTime = new OptionalTimeSpan(OptionalTimeSpan.Type.Max);
        this.lmtStartedTime.addOptional(Duration.ZERO);
        this.lmtEndedTime = new OptionalTimeSpan(OptionalTimeSpan.Type.Min);
        this.lmtEndedTime.addOptional(producedDeliveryTime);
        this.jobData = new HashMap<String,Object>();
        this.tasks = new LinkedList<Task>();
    }

    /*
     * Id
     */
    private String id;

    /*
     * Job Data
     */
    private Map<String, Object> jobData;

    /*
     * 生产交期
     */
    private Duration producedDeliveryTime;

    /*
     * 生产交期
     */
    private LocalDateTime producedDeliveryDate;

    /*
     * 开始时间限制线
     */
    private OptionalTimeSpan lmtStartedTime;

    /*
     * 结束时间限制线
     */
    private OptionalTimeSpan lmtEndedTime;

    /*
     * 排产开始时间
     */
    private Duration scheduledStartedTime;

    /*
     * 排产结束时间
     */
    private Duration scheduledEndedTime;

    /*
     * 排产结果
     */
    private ScheduleStatus scheduleStatus;

    /*
     * 排产结果描述
     */
    private String scheduleDesc;

    /*
     * 是否锁定
     */
    private Boolean fixed;

    /*
     * 作业列表
     */
    private LinkedList<Task> tasks;

    /**
     * 投产数量
     */
    private BigDecimal quantity;

    /**
     * job扩展属性
     */
    private JobExtent jobExtend=new JobExtent();

}
