package com.ximai.mes.pro.schedule;

import lombok.Data;

import java.math.BigDecimal;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;

@Data
public abstract class Calendar {


    /*
    * CalendarData
    */
    public Map<String, Object> calendarData= new HashMap<String, Object>();

    /*
    * 资源
    */
    private Resource resource;

    /*
     * 开始时间
     */
    private Duration startedTime;

    /*
     * 结束时间
     */
    private Duration endedTime;


    /*
     * 开始时间
     */
    private LocalDateTime startedTime2;

    /*
     * 结束时间
     */
    private LocalDateTime endedTime2;

    /**
     *  占用日历
     */
    @Data
    public static class OccupiedCalendar extends Calendar{

        /*
         * Job
         */
        private Job job;

        /*
         * Task
         */
        private Task task;

        /*
         * 数量
         */
        private BigDecimal quantity;
    }


    /**
     * 工作日历
     */
    public static class WorkingCalendar extends Calendar {

        String shiftType;

        public String getShiftType() {
            return shiftType;
        }

        public void setShiftType(String shiftType) {
            this.shiftType = shiftType;
        }
    }


    /**
     * 空闲日历
     */
    public static class LeisureCalendar extends Calendar {
        String shiftType;

        public String getShiftType() {
            return shiftType;
        }

        public void setShiftType(String shiftType) {
            this.shiftType = shiftType;
        }
    }


}
