package com.ximai.mes.pro.mapper.productionMake;

import java.util.List;
import com.ximai.mes.pro.domain.productionMake.ProProductionMakeProcessItem;

/**
 * 量产制作工序物料Mapper接口
 *
 * @author chicheng.li
 * @date 2024-01-23
 */
public interface ProProductionMakeProcessItemMapper
{
    /**
     * 查询量产制作工序物料
     *
     * @param productionMakeProcessItemId 量产制作工序物料主键
     * @return 量产制作工序物料
     */
    public ProProductionMakeProcessItem selectProProductionMakeProcessItemByProductionMakeProcessItemId(Long productionMakeProcessItemId);

    /**
     * 查询量产制作工序物料列表
     *
     * @param proProductionMakeProcessItem 量产制作工序物料
     * @return 量产制作工序物料集合
     */
    public List<ProProductionMakeProcessItem> selectProProductionMakeProcessItemList(ProProductionMakeProcessItem proProductionMakeProcessItem);

    /**
     * 新增量产制作工序物料
     *
     * @param proProductionMakeProcessItem 量产制作工序物料
     * @return 结果
     */
    public int insertProProductionMakeProcessItem(ProProductionMakeProcessItem proProductionMakeProcessItem);

    /**
     * 修改量产制作工序物料
     *
     * @param proProductionMakeProcessItem 量产制作工序物料
     * @return 结果
     */
    public int updateProProductionMakeProcessItem(ProProductionMakeProcessItem proProductionMakeProcessItem);

    /**
     * 删除量产制作工序物料
     *
     * @param productionMakeProcessItemId 量产制作工序物料主键
     * @return 结果
     */
    public int deleteProProductionMakeProcessItemByProductionMakeProcessItemId(Long productionMakeProcessItemId);

    /**
     * 批量删除量产制作工序物料
     *
     * @param productionMakeProcessItemIds 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteProProductionMakeProcessItemByProductionMakeProcessItemIds(Long[] productionMakeProcessItemIds);

    /**
     * 批量删除量产制作工序物料
     *
     * @param productionMakeId 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteProProductionMakeProcessItemByProductionMakeId(Long productionMakeId);
}
