package com.ximai.mes.pro.mapper.proWorkOrder;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ximai.mes.pro.domain.proWorkOrder.ProWorkOrderProcess;
import com.ximai.mes.pro.domain.proWorkOrder.ProWorkOrderProcessItem;
import com.ximai.mes.pro.domain.vo.ProWorkOrderProcessVo;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * 生产工单工序Mapper接口
 * a
 *
 * @author yinjinlu
 * @date 2024-01-23
 */
public interface ProWorkOrderProcessMapper {
    /**
     * 根据工单id查询所属所有工序
     *
     * @param workorderId
     * @return
     */
    List<ProWorkOrderProcessVo> selectProWorkOrderProcessByWorkOrderId(Long workorderId);


    /**
     * 查询所属所有工序
     *
     * @param query
     * @return
     */
    @Select(value = "select pwop.workorder_process_id,\n" +
            "               pwop.workorder_id,\n" +
            "               pwop.workstation_id,\n" +
            "               pwop.std_working_time,\n" +
            "               pwop.default_pre_time,\n" +
            "               pwop.default_suf_time,\n" +
            "               pwop.key_flag,\n" +
            "               pwop.is_check,\n" +
            "               pwop.remark,\n" +
            "               pp.process_name,\n" +
            "               pp.process_code,\n" +
            "               pp.process_id,\n" +
            "               pwop.idx,\n" +
            "               mw.workstation_name\n" +
            "        from pro_work_order_process pwop\n" +
            "                 left join pro_process pp on pwop.process_id = pp.process_id\n" +
            "                 left join md_workstation mw on pwop.workstation_id = mw.workstation_id\n" +
            "${ew.customSqlSegment} order by pwop.idx")
    List<ProWorkOrderProcessVo> selectProWorkOrderProcess(@Param("ew") QueryWrapper<ProWorkOrderProcessVo> query);

    /**
     * 查询生产工单工序
     *
     * @param workorderProcessId 生产工单工序主键
     * @return 生产工单工序
     */
    ProWorkOrderProcessVo selectProWorkOrderProcessByWorkorderProcessId(Long workorderProcessId);

    /**
     * 查询生产工单工序列表
     *
     * @param proWorkOrderProcess 生产工单工序
     * @return 生产工单工序集合
     */
    List<ProWorkOrderProcessVo> selectProWorkOrderProcessList(ProWorkOrderProcess proWorkOrderProcess);

    /**
     * 新增生产工单工序
     *
     * @param proWorkOrderProcess 生产工单工序
     * @return 结果
     */
    int insertProWorkOrderProcess(ProWorkOrderProcess proWorkOrderProcess);

    /**
     * 修改生产工单工序
     *
     * @param proWorkOrderProcess 生产工单工序
     * @return 结果
     */
    int updateProWorkOrderProcess(ProWorkOrderProcess proWorkOrderProcess);

    /**
     * 删除生产工单工序
     *
     * @param workorderProcessId 生产工单工序主键
     * @return 结果
     */
    int deleteProWorkOrderProcessByWorkorderProcessId(Long workorderProcessId);

    /**
     * 批量删除生产工单工序
     *
     * @param workorderProcessIds 需要删除的数据主键集合
     * @return 结果
     */
    int deleteProWorkOrderProcessByWorkorderProcessIds(Long[] workorderProcessIds);


    @Select(value = "select t1.*,t2.workstation_name,t2.workstation_code,t3.product_id,t3.product_name,t3.arrange_code from pro_work_order_process t1 inner  join pro_process pp on pp.process_id = t1.process_id left join md_workstation t2 on t1.workstation_id = t2.workstation_id left join pro_workorder t3 on t1.workorder_id = t3.workorder_id\n" +
            "${ew.customSqlSegment}")
    List<ProWorkOrderProcess> selectListByQw(@Param("ew") QueryWrapper<ProWorkOrderProcess> queryProcess);


    @Select(value = "select x2.task_workunit_id, x1.workorder_code,pp.is_exist_tool,x1.process_id,x1.workorder_process_id,x1.idx,pp.is_exist_tool from pro_work_order_process x1 inner  join (\n" +
            "select distinct t3.arrange_code,t3.workorder_code,t2.process_id,t1.task_workunit_id from pro_task_workunit t1 inner join pro_task t2 on t1.task_id = t2.task_id inner  join  pro_workorder t3 on t3.arrange_code = t2.arrange_code where t1.task_workunit_id = #{taskWorkunitId}\n" +
            ") x2 on x1.workorder_code = x2.workorder_code   and x1.process_id = x2.process_id inner  join pro_process pp on pp.process_id = x1.process_id where pp.is_exist_tool = 1")
    List<ProWorkOrderProcess> selectProcessIsExistToolByTwId(Long taskWorkunitId);

    /**
     * 删除生产工单工序
     *
     * @param workorderId 生产工单主键
     * @return 结果
     */
    int deleteProWorkOrderProcessByWorkorderId(Long workorderId);


    @Delete("delete from pro_work_order_process where workorder_code=#{workorderCode} ")
    void deleteByWorkorderCode(@Param("workorderCode") String workorderCode);

    @Select("select  DISTINCT w.requirement_number,w.requirement_project_number ,md.item_id, md.item_code, md.item_name, md.specification, md.item_type_name\n" +
            "           t, md.unit_of_measure\n" +
            "            from pro_work_order_process_item w\n" +
            "            left join pro_work_order_process m on w.workorder_process_id = m.workorder_process_id\n" +
            "            left join md_item md on w.item_id = md.item_id  ${ew.customSqlSegment}")
    List<ProWorkOrderProcessItem> selectProWorkOrderProcessOrWorkorder(@Param("ew") QueryWrapper<ProWorkOrderProcess> queryProcess);

    @Delete(value = "delete from pro_work_order_process  ${ew.customSqlSegment}")
    void deleteProWorkOrderProcess(@Param("ew") QueryWrapper<ProWorkOrderProcess> queryWrapper);

    @Select(value = "select t1.*,t2.* from pro_work_order_process_item t1 \n" +
            "left join  pro_work_order_process t2 on t1.workorder_process_id= t2.workorder_process_id  \n" +
            " ${ew.customSqlSegment}")
    List<ProWorkOrderProcessItem> selectProWorkOrderProcessItem(@Param("ew") QueryWrapper<ProWorkOrderProcess> itemQuery);
}
