package com.ximai.mes.pro.mapper.proWorkOrder;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.ximai.mes.pro.domain.proWorkOrder.ProWorkOrderArrangeRuleVal;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;

import java.util.List;
import java.util.Map;

/**
 * 工单编排规则属性唯一值Mapper接口
 *
 * @author generator
 * @date 2024-03-26
 */
public interface ProWorkOrderArrangeRuleValMapper extends BaseMapper<ProWorkOrderArrangeRuleVal> {
    /**
     * 查询工单编排规则属性唯一值
     *
     * @param arrangeRuleId 工单编排规则属性唯一值主键
     * @return 工单编排规则属性唯一值
     */
    ProWorkOrderArrangeRuleVal selectProWorkOrderArrangeRuleValByArrangeRuleId(Long arrangeRuleId);

    /**
     * 查询工单编排规则属性唯一值列表
     *
     * @param proWorkOrderArrangeRuleVal 工单编排规则属性唯一值
     * @return 工单编排规则属性唯一值集合
     */
    List<ProWorkOrderArrangeRuleVal> selectProWorkOrderArrangeRuleValList(ProWorkOrderArrangeRuleVal proWorkOrderArrangeRuleVal);

    /**
     * 查询工单编排规则属性唯一值列表
     *
     * @param query 工单编排规则属性唯一值
     * @return 工单编排规则属性唯一值集合
     */
    @Select(value = "select * from pro_work_order_arrange_rule_val ${ew.customSqlSegment}")
    List<Map<String, Object>> selectProWorkOrderArrangeRuleVal(@Param("ew") QueryWrapper<ProWorkOrderArrangeRuleVal> query);

    /**
     * 新增工单编排规则属性唯一值
     *
     * @param proWorkOrderArrangeRuleVal 工单编排规则属性唯一值
     * @return 结果
     */
    int insertProWorkOrderArrangeRuleVal(ProWorkOrderArrangeRuleVal proWorkOrderArrangeRuleVal);

    /**
     * 修改工单编排规则属性唯一值
     *
     * @param proWorkOrderArrangeRuleVal 工单编排规则属性唯一值
     * @return 结果
     */
    int updateProWorkOrderArrangeRuleVal(ProWorkOrderArrangeRuleVal proWorkOrderArrangeRuleVal);

    /**
     * 删除工单编排规则属性唯一值
     *
     * @param arrangeRuleId 工单编排规则属性唯一值主键
     * @return 结果
     */
    int deleteProWorkOrderArrangeRuleValByArrangeRuleId(Long arrangeRuleId);

    /**
     * 批量删除工单编排规则属性唯一值
     *
     * @param arrangeRuleIds 需要删除的数据主键集合
     * @return 结果
     */
    int deleteProWorkOrderArrangeRuleValByArrangeRuleIds(Long[] arrangeRuleIds);

    /**
     * 查询工单编排规则属性唯一值列表
     *
     * @param workorderId 工单编排规则属性唯一值
     * @return 工单编排规则属性唯一值集合
     */
    @Update(value = "delete from pro_work_order_arrange_rule_val where workorder_id = #{workorderId}")
    void deleteByWorkorderId(@Param("workorderId") Long workorderId);


}
