package com.ximai.mes.pro.domain.vo.task;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 派工任务转自制参数
 *
 * @author chicheng.li
 * @date 2024-09-10
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class TaskWorkunitToSelfMadeParam  {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("派工任务ID")
    private Long taskWorkunitId;

    @ApiModelProperty("转自制数量")
    private BigDecimal toSelfMadeQuantity;

    @ApiModelProperty("计划结束时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date scheduleStartDate;

    @ApiModelProperty("计划结束时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date scheduleEndDate;

    @ApiModelProperty("工作单元Id")
    private Long workunitId;

    @ApiModelProperty("工作单元编码")
    private String workunitCode;

}
