package com.ximai.mes.pro.domain.vo.task;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 包装工序报工记录查询
 *
 * @date 2024-05-13
 */
@Data
public class FeedbackPackageQueryParams {

    @ApiModelProperty("生产工单ID")
    private Long workorderId;

    @ApiModelProperty("生产任务ID")
    private Long taskId;

    @ApiModelProperty("包装数量")
    private Integer packNum;

    @ApiModelProperty("装箱数量")
    private Integer encasementNum;

    @ApiModelProperty("是否合并包装,1：是，0：否")
    private Integer mergePack;

    @ApiModelProperty("排产数量")
    private BigDecimal quantity;

    /**
     * 包装数量、装箱数量、是否合并包装为NULL，都默认为0
     * 如果装箱数不为0，包装数量为0，包装数=装箱数量
     */
    public void initPackageValue(){
        if(this.getMergePack()==null){
            setMergePack(0);
        }
        if(this.getPackNum()==null){
            setPackNum(0);
        }
        if(this.getEncasementNum()==null){
            setEncasementNum(0);
        }
        if(this.getPackNum()==0&&this.getEncasementNum()!=0){
            setPackNum(this.getEncasementNum());
        }
    }

}
