package com.ximai.mes.pro.domain.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;
import com.ximai.mes.pro.domain.proWorkOrder.ProWorkOrderProcessItem;
import com.ximai.mes.pro.domain.proWorkOrder.ProWorkOrderProcessQcindex;
import com.ximai.mes.pro.domain.proWorkOrder.ProWorkOrderProcessTool;
import com.ximai.mes.pro.domain.productionSolution.ProProductionSolutionProcess;
import com.ximai.mes.pro.domain.task.ProTaskAssistProcess;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 生产工单工序对象 pro_work_order_process
 *
 * @author yinjinlu
 * @date 2024-01-23
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class ProWorkOrderProcessVo extends BaseEntity {
    private static final long serialVersionUID = 1L;
    /**
     * ID
     */
    @ApiModelProperty("工单工序ID")
    private Long workorderProcessId;

    private Long workunitId;

    private String workunitCode;
    private String workunitName;
    /**
     * 生产工单ID
     */
    private Long workorderId;

    private String workorderCode;

    /**
     * 序号
     */
    private String idx;

    @TableField(exist = false)
    private int isExistTool;
    /**
     * 工作中心
     */
    @ApiModelProperty("工作中心ID")
    private Long workstationId;


    @Excel(name = "工作中心名称")
    @ApiModelProperty("工作中心名称")
    @TableField(exist = false)
    private String workstationName;


    @Excel(name = "工作中心编码")
    @ApiModelProperty("工作中心编码")
    @TableField(exist = false)
    private String workstationCode;

    /**
     * 标准工时
     */
    @ApiModelProperty("标准工时")
    private BigDecimal stdWorkingTime;

    /**
     * 关键工序
     */
    private String keyFlag;

    /**
     * 是否检验
     */
    private String isCheck;

    private String processRef;

    /**
     * 工序id
     */
    private Long processId;

    /**
     * 工序名称
     */
    @Excel(name = "工序名称")
    @ApiModelProperty("工序名称")
    private String processName;

    /**
     * 变更编号
     */
    @Excel(name = "变更编号")
    private String enCode;

    /**
     * 工序编码
     */
    @Excel(name = "工序编码")
    private String processCode;


    /**
     * 工时单位
     */
    @ApiModelProperty("工时单位")
    private String stdWorkingTimeUom;

    /**
     * 下一道工序的名称
     */
    @Excel(name = "下一道工序的名称")
    private String nextProcessName;


    /**
     * 与下一道工序的关系
     */
    @Excel(name = "与下一道工序的关系")
    private String linkType;

    /**
     * 甘特图颜色
     */
    private String colorCode;

    /**
     * 加工方式
     */
    @Excel(name = "加工方式")
    private String controlCode;

    /**
     * 标准文本码
     */
    @Excel(name = "标准文本码")
    private String x;

    /**
     * 工序总数量
     */
    @Excel(name = "工序总数量")
    @ApiModelProperty("工序总数量")
    private BigDecimal quantity;

    private Long assistQuantity = 0L;
    /**
     * 换型时间
     */
    @Excel(name = "换型时间")
    @ApiModelProperty("换型时间")
    private BigDecimal lineBreakTime;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date startTime;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date endTime;

    @ApiModelProperty("是否外协")
    private String outsourced;
    /**
     * 单价
     */
    private BigDecimal unitPrice;

    /**
     * 工序物料
     */
    private List<ProWorkOrderProcessItem> processItemList;

    /**
     * 工序工装
     */
    private List<ProWorkOrderProcessQcindex> qcindexList;
    /**
     * 工序质检
     */
    private List<ProWorkOrderProcessTool> toolList;


    private ProProductionSolutionProcess proProductionSolutionProcess;


    private List<ProTaskAssistProcess> proTaskAssistProcessList;

}
