package com.ximai.mes.pro.domain.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;
import com.ximai.mes.pro.domain.task.ProTaskWorkunit;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.util.Date;

/**
 * title:
 * author:ZHT
 * date:2024/1/24
 * description:
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class ProTaskVo extends BaseEntity {
    private static final long serialVersionUID = 1L;


    /**
     * 任务ID
     */
    private Long taskId;

    /**
     * 任务编号
     */
    @Excel(name = "任务编号")
    private String taskCode;

    /**
     * 任务名称
     */
    @Excel(name = "任务名称")
    private String taskName;

    private Integer taskType;
    /**
     * 生产工单ID
     */
    @Excel(name = "生产工单ID")
    private Long workorderId;

    /**
     * 生产工单编号
     */
    @Excel(name = "生产工单编号")
    private String workorderCode;

    /**
     * 工单名称
     */
    @Excel(name = "工单名称")
    private String workorderName;

    /**
     * 工作中心ID
     */
    @Excel(name = "工作中心ID")
    private Long workstationId;

    /**
     * 工作中心编号
     */
    @Excel(name = "工作中心编号")
    private String workstationCode;

    /**
     * 工作中心名称
     */
    @Excel(name = "工作中心名称")
    private String workstationName;

    private Long routeId;

    private String routeCode;

    private String routeName;

    /**
     * 工序ID
     */
    @Excel(name = "工序ID")
    private Long processId;

    /**
     * 工序编码
     */
    @Excel(name = "工序编码")
    private String processCode;

    /**
     * 工序名称
     */
    @Excel(name = "工序名称")
    private String processName;

    private String isCheck;

    /**
     * 产品物料ID
     */
    @Excel(name = "产品物料ID")
    private Long itemId;

    /**
     * 产品物料编码
     */
    @Excel(name = "产品物料编码")
    private String itemCode;

    /**
     * 产品物料名称
     */
    @Excel(name = "产品物料名称")
    private String itemName;

    /**
     * 规格型号
     */
    @Excel(name = "规格型号")
    private String specification;

    /**
     * 单位
     */
    @Excel(name = "单位")
    private String unitOfMeasure;

    /**
     * 排产数量
     */
    @Excel(name = "排产数量")
    private BigDecimal quantity;

    /**
     * 排产数量
     */
    private BigDecimal quantityWait;

    /**
     * 已生产数量
     */
    @Excel(name = "已生产数量")
    private BigDecimal quantityProduced;

    private BigDecimal quantityQuanlify;

    private BigDecimal quantityUnquanlify;

    /**
     * 调整数量
     */
    @Excel(name = "调整数量")
    private BigDecimal quantityChanged;

    private Long taskWorkunitId;
    /**
     * 客户ID
     */
    @Excel(name = "客户ID")
    private Long clientId;

    /**
     * 客户编码
     */
    @Excel(name = "客户编码")
    private String clientCode;

    /**
     * 客户名称
     */
    @Excel(name = "客户名称")
    private String clientName;

    /**
     * 客户简称
     */
    @Excel(name = "客户简称")
    private String clientNick;
    /**
     * 开始生产时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "开始生产时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date scheduleStartDate;

    /**
     * 开始生产时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "开始生产时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date scheduleEndDate;


    /**
     * 开始生产时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "开始生产时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date startTime;

    /**
     * 生产时长
     */
    @Excel(name = "生产时长")
    private Long duration;

    /**
     * 完成生产时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "完成生产时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date endTime;

    /**
     * 甘特图显示颜色
     */
    @Excel(name = "甘特图显示颜色")
    private String colorCode;

    /**
     * 需求日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "需求日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date requestDate;

    private String status;

    /**
     * 预留字段1
     */
    private String attr1;

    /**
     * 预留字段2
     */
    private String attr2;

    /**
     * 预留字段3
     */
    private Long attr3;

    /**
     * 预留字段4
     */
    private Long attr4;

    /**
     * 工作单元
     */
    private Long workunitId;

    private String workunitName;

    private String workunitCode;

    /**
     * 编号
     */
    private Long idx;


    @TableField(exist = false)
    private ProTaskWorkunit taskWorkunit;
}
