package com.ximai.mes.pro.domain.vo;

import com.ximai.common.core.domain.BaseEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 报工包装标签打印记录表对象 pro_package_print_record
 *
 * @author generator
 * @date 2024-03-19
 */
@Data
public class ProPackagePrintRecordVo extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("打印标签ID")
    private Long recordId;

    /** 工单ID */
    @ApiModelProperty("工单ID")
    private Long workorderId;

    /** 工单指令ID */
    @ApiModelProperty("工单指令ID")
    private Long workorderSoDirectiveId;

    @ApiModelProperty("工单SIZE")
    private Long workorderSoSizeItemId;

    /** 报工单ID */
    @ApiModelProperty("报工单ID")
    private Long feedbackId;

    @ApiModelProperty("条码")
    private String barcode;

    @ApiModelProperty("二维码")
    private String qrcode;

    @ApiModelProperty("净重")
    private BigDecimal netWeight;

    @ApiModelProperty("录入人员")
    private String inputBy;

    @ApiModelProperty("检验人员")
    private String checkBy;

    @ApiModelProperty("包装数量")
    private String packageNum;

    @ApiModelProperty("包装数量")
    private BigDecimal packageNum2;

    @ApiModelProperty("LOSS数量")
    private Integer lossNum;

    @ApiModelProperty("标准SIZE")
    private String standardSize;

    @ApiModelProperty("指令")
    private String directive;

    @ApiModelProperty("当前面码")
    private Integer sheetCount;

    @ApiModelProperty("小包当前页码")
    private Integer minSheetCount;

    @ApiModelProperty("打印次数")
    private Integer printTime;

    @ApiModelProperty("是否超报标签，1：是，0：否")
    private Integer isSurplus=0;

}
