package com.ximai.mes.pro.domain.task;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.ximai.common.annotation.Excel;
import com.baomidou.mybatisplus.annotation.TableId;
import com.ximai.common.core.domain.BaseEntity;
import lombok.Data;

/**
 * 任务派工修改记录对象 pro_task_workunit_op_record
 *
 * @author generator
 * @date 2024-08-13
 */
@Data
public class ProTaskWorkunitOpRecord extends BaseEntity {
    private static final long serialVersionUID = 1L;

    /** id */
    @TableId
    private Long id;

    /** 派工单ID */
    @Excel(name = "派工单ID")
    private Long taskWorkunitId;

    /** 任务ID */
    @Excel(name = "任务ID")
    private Long taskId;

    /** 顺序号 */
    @Excel(name = "顺序号")
    private Long idx;

    /** 工作单元ID */
    @Excel(name = "工作单元ID")
    private Long oldWorkunitId;

    /** 工作单元ID */
    @Excel(name = "工作单元ID")
    private Long workunitId;

    /** 排产开始时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "排产开始时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date oldScheduleStartDate;

    /** 排产结束时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "排产结束时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date oldScheduleEndDate;

    /** 排产开始时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "排产开始时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date scheduleStartDate;

    /** 排产结束时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "排产结束时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date scheduleEndDate;

}
