package com.ximai.mes.pro.controller.productionSolution;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import com.ximai.mes.pro.domain.productionSolution.ProProductionSolutionProcessQcindex;
import com.ximai.mes.pro.service.productionSolution.IProProductionSolutionProcessQcindexService;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.enums.BusinessType;

import com.ximai.common.core.page.TableDataInfo;

/**
 * 生产版本工序检验项Controller
 *
 * @author generator
 * @date 2024-01-28
 */
@RestController
@RequestMapping("/md/qcindex")
public class ProProductionSolutionProcessQcindexController extends BaseController
{
    @Autowired
    private IProProductionSolutionProcessQcindexService proProductionSolutionProcessQcindexService;

    /**
     * 查询生产版本工序检验项列表
     */
    @PreAuthorize("@ss.hasPermi('md:qcindex:list')")
    @GetMapping("/list")
    public TableDataInfo list(ProProductionSolutionProcessQcindex proProductionSolutionProcessQcindex)
    {
        startPage();
        List<ProProductionSolutionProcessQcindex> list = proProductionSolutionProcessQcindexService.selectProProductionSolutionProcessQcindexList(proProductionSolutionProcessQcindex);
        return getDataTable(list);
    }


    /**
     * 获取生产版本工序检验项详细信息
     */
    @PreAuthorize("@ss.hasPermi('md:qcindex:query')")
    @GetMapping(value = "/{prototypeRequestProcessQcindexId}")
    public AjaxResult getInfo(@PathVariable("prototypeRequestProcessQcindexId") Long prototypeRequestProcessQcindexId)
    {
        return AjaxResult.success(proProductionSolutionProcessQcindexService.selectProProductionSolutionProcessQcindexByPrototypeRequestProcessQcindexId(prototypeRequestProcessQcindexId));
    }

    /**
     * 新增生产版本工序检验项
     */
    @PreAuthorize("@ss.hasPermi('md:qcindex:add')")
    @Log(title = "生产版本工序检验项", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody ProProductionSolutionProcessQcindex proProductionSolutionProcessQcindex)
    {
        return toAjax(proProductionSolutionProcessQcindexService.insertProProductionSolutionProcessQcindex(proProductionSolutionProcessQcindex));
    }

    /**
     * 修改生产版本工序检验项
     */
    @PreAuthorize("@ss.hasPermi('md:qcindex:edit')")
    @Log(title = "生产版本工序检验项", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody ProProductionSolutionProcessQcindex proProductionSolutionProcessQcindex)
    {
        return toAjax(proProductionSolutionProcessQcindexService.updateProProductionSolutionProcessQcindex(proProductionSolutionProcessQcindex));
    }

    /**
     * 删除生产版本工序检验项
     */
    @PreAuthorize("@ss.hasPermi('md:qcindex:remove')")
    @Log(title = "生产版本工序检验项", businessType = BusinessType.DELETE)
	@DeleteMapping("/{prototypeRequestProcessQcindexIds}")
    public AjaxResult remove(@PathVariable Long[] prototypeRequestProcessQcindexIds)
    {
        return toAjax(proProductionSolutionProcessQcindexService.deleteProProductionSolutionProcessQcindexByPrototypeRequestProcessQcindexIds(prototypeRequestProcessQcindexIds));
    }
}
