package com.ximai.mes.pro.controller;

import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.core.page.TableDataInfo;
import com.ximai.common.enums.BusinessType;
import com.ximai.mes.pro.domain.ProAllocationMaterial;
import com.ximai.mes.pro.domain.vo.ProAllocationMaterialVo;
import com.ximai.mes.pro.service.IProAllocationMaterialService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 调拨料申请Controller
 *
 * @author generator
 * @date 2024-05-14
 */
@RestController
@RequestMapping("/pro/ProAllocationMaterial")
public class ProAllocationMaterialController extends BaseController {
    @Autowired
    private IProAllocationMaterialService proAllocationMaterialService;

    /**
     * 查询调拨料申请列表
     */
    @PreAuthorize("@ss.hasPermi('allocation:ProAllocationMaterial:list')")
    @GetMapping("/list")
    public TableDataInfo list(ProAllocationMaterial proAllocationMaterial) {
        startPage();
        List<ProAllocationMaterial> list = proAllocationMaterialService.selectProAllocationMaterialList(proAllocationMaterial);
        return getDataTable(list);
    }

    /**
     * 获取调拨料申请详细信息
     */
    @PreAuthorize("@ss.hasPermi('allocation:ProAllocationMaterial:query')")
    @GetMapping(value = "/{allocationMaterialId}")
    public AjaxResult getInfo(@PathVariable("allocationMaterialId") Long allocationMaterialId) {
        return AjaxResult.success(proAllocationMaterialService.selectProAllocationMaterialByAllocationMaterialId(allocationMaterialId));
    }

    /**
     * 新增调拨料申请
     */
    @PreAuthorize("@ss.hasPermi('allocation:ProAllocationMaterial:add')")
    @Log(title = "调拨料申请", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody ProAllocationMaterialVo proAllocationMaterialvo) {
        proAllocationMaterialvo.setBuildMethod(0L);
        return toAjax(proAllocationMaterialService.insertProAllocationMaterialManual(proAllocationMaterialvo));
    }

    /**
     * 修改调拨料申请
     */
    @PreAuthorize("@ss.hasPermi('allocation:ProAllocationMaterial:edit')")
    @Log(title = "调拨料申请", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody ProAllocationMaterial proAllocationMaterial) {
        return toAjax(proAllocationMaterialService.updateProAllocationMaterial(proAllocationMaterial));
    }

    /**
     * 删除调拨料申请
     */
    @PreAuthorize("@ss.hasPermi('allocation:ProAllocationMaterial:remove')")
    @Log(title = "调拨料申请", businessType = BusinessType.DELETE)
    @DeleteMapping("/{allocationMaterialIds}")
    public AjaxResult remove(@PathVariable Long[] allocationMaterialIds) {
        return toAjax(proAllocationMaterialService.deleteProAllocationMaterialByAllocationMaterialIds(allocationMaterialIds));
    }
}
