package com.ximai.mes.od.domain;

import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

/**
 * 销售订单产品详情对象 od_sales_order_product_detail
 *
 * @author yinjinlu
 * @date 2024-01-18
 */
public class OdSalesOrderProductDetail extends BaseEntity {
    private static final long serialVersionUID = 1L;

    /**
     * $column.columnComment
     */
    private String id;

    /**
     * 订单详情id
     */
    @Excel(name = "订单详情id")
    private Long orderDetailId;

    private Long specId;

    /**
     * 产品尺码key
     */
    @Excel(name = "产品尺码key")
    private String specKey;

    /**
     * 产品尺码val
     */
    @Excel(name = "产品尺码val")
    private String specVal;

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return id;
    }

    public void setOrderDetailId(Long orderDetailId) {
        this.orderDetailId = orderDetailId;
    }

    public Long getOrderDetailId() {
        return orderDetailId;
    }

    public Long getSpecId() {
        return specId;
    }

    public void setSpecId(Long specId) {
        this.specId = specId;
    }

    public void setSpecKey(String specKey) {
        this.specKey = specKey;
    }

    public String getSpecKey() {
        return specKey;
    }

    public void setSpecVal(String specVal) {
        this.specVal = specVal;
    }

    public String getSpecVal() {
        return specVal;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE)
                .append("id", getId())
                .append("orderDetailId", getOrderDetailId())
                .append("key", getSpecKey())
                .append("productSizeVal", getSpecVal())
                .append("createTime", getCreateTime())
                .append("updateTime", getUpdateTime())
                .toString();
    }
}
