package com.ximai.mes.od.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 销售订单对象 od_sales_order
 *
 * @author yinjinlu
 * @date 2024-01-18
 */
@Data
public class OdSalesOrder extends BaseEntity {
    private static final long serialVersionUID = 1L;

    /**  */
    private Long id;

    /** 申购号 */
    @Excel(name = "申购号")
    private String purchaseNo;

    /** 客户采购订单日期 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "客户采购订单日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date purchaseDate;

    /** 客户ID */
    @Excel(name = "客户ID")
    private Long clientId;

    /** 客户编码 */
    @Excel(name = "客户编码")
    private String clientNo;

    /** 客户名称 */
    @Excel(name = "客户名称")
    private String clientName;

    /** sap客户编码 */
    @Excel(name = "sap客户编码")
    private String sapClientCode;

    /** 订单编号 */
    @Excel(name = "订单编号")
    private String orderNo;

    /** 订单编号 */
    @Excel(name = "sap订单编号")
    private String sapOrderNo;

    /** 订单销售类型 */
    @Excel(name = "订单销售类型")
    private String typeNo;

    /** 总金额 */
    @Excel(name = "总金额")
    private BigDecimal amount;

    /** 跟单人 */
    @Excel(name = "跟单人")
    private String merchandiser;

    /** 客户定制信息 */
    @Excel(name = "客户定制信息")
    private String custom;

    /** 销售组织 */
    @Excel(name = "销售组织")
    private String orgNo;

    /** 分销渠道 */
    @Excel(name = "分销渠道")
    private String channelNo;

    /** 订单原因 */
    @Excel(name = "订单原因")
    private String reasonNo;

    /** 销售办事处 */
    @Excel(name = "销售办事处")
    private String agencyNo;

    /** 销售小组 */
    @Excel(name = "销售小组")
    private String groupNo;

    /** 销售币别 */
    @Excel(name = "销售币别")
    private String currencyNo;

    /** 要求交货期 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "要求交货期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date deliveryDate;

    /** 国际贸易条款 */
    @Excel(name = "国际贸易条款")
    private String clauseNo;

    /** 国际贸易条款地址 */
    @Excel(name = "国际贸易条款地址")
    private String clauseAddr;

    /** 凭证货币中销售订单的净值 */
    @Excel(name = "凭证货币中销售订单的净值")
    private String netValue;

    /** 付款条件 */
    @Excel(name = "付款条件")
    private String paymentClause;

    /** 产品组 */
    @Excel(name = "产品组")
    private String itemGroup;

    /** 客户采购订单编号 */
    @Excel(name = "客户采购订单编号")
    private String poPurchaseNo;

    /** 发货方式 */
    @Excel(name = "发货方式")
    private String despatchType;

    /** 条码 */
    @Excel(name = "条码")
    private String barCode;

    /** 加急 */
    @Excel(name = "加急")
    private Long urgent;

    /** osp订单号 */
    @Excel(name = "osp订单号")
    private String ospNo;

    /** 订单状态 */
    @Excel(name = "订单状态")
    private String state;

    private List<OdSalesOrderDetail> detailList;

}
