package com.ximai.mes.md.vo;

import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;

/**
 * 工作单元对象 md_workunit
 *
 * @author yinjinlu
 * @date 2024-01-18
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class MdWorkunitVo extends BaseEntity {
    private static final long serialVersionUID = 1L;

    /**
     * 工作单元ID
     */
    private Long workunitId;
    private Long taskId;
    private String taskCode;
    private String taskName;
    private Long itemId;
    private String itemCode;
    private String itemName;
    private Integer nextMaintenPeriod;
    private Integer allQuantity;

    private Integer type;
    /**
     * 工作站ID
     */
    @Excel(name = "工作站ID")
    private Long workstationId;

    /**
     * 工作站名称
     */
    @Excel(name = "工作站名称")
    private String workstationName;

    @ApiModelProperty("机台顺序")
    private Integer serial;

    /**
     * 工作站编码
     */
    @Excel(name = "工作站编码")
    private String workstationCode;


    /**
     * 工作单元编码
     */
    @Excel(name = "工作单元编码")
    private String workunitCode;

    /**
     * 工作单元名称
     */
    @Excel(name = "工作单元名称")
    private String workunitName;

    /**
     * 是否故障
     */
    @Excel(name = "是否故障")
    private String faultFlag;

    /**
     * 是否启用
     */
    @Excel(name = "是否启用")
    private String enableFlag;

    /**
     * 工序名称
     */
    private String processName;
    /**
     * 工序ID
     */
    private String processId;

    /**
     * 更新表志
     */
    private char updateLog;

    String userName;

    private String workshopName;

    /** 固化时间 */
    @Excel(name = "固化时间")
    private BigDecimal solidifyTime;

    /** 加工处理最小厚度 */
    @Excel(name = "加工处理最小厚度")
    private BigDecimal treatingThicknessMin;

    /** 加工处理最大厚度 */
    @Excel(name = "加工处理最大厚度")
    private BigDecimal treatingThicknessMax;

    /** 加工处理最小宽度 */
    @Excel(name = "加工处理最小宽度")
    private BigDecimal treatingWidthMin;

    /** 加工处理最大宽度 */
    @Excel(name = "加工处理最大宽度")
    private BigDecimal treatingWidthMax;


    /** 凹印_胶版油槽数 */
    @Excel(name = "凹印_胶版油槽数")
    private BigDecimal dieSunkOffsetOilTankNum;

    /** 印刷方式 */
    @Excel(name = "印刷方式")
    private String printingMethod;

    /**
     * 转间配送时间
     */
    @ApiModelProperty("转间配送时间")
    private BigDecimal transferTime;

    /** 封切机开边 */
    @Excel(name = "封切机开边")
    private String sacmForEdgeOpening;

    /** 封切机粘贴复合 */
    @Excel(name = "封切机粘贴复合")
    private String sacmForPasteComposite;

    /** 封切机热复合 */
    @Excel(name = "封切机热复合")
    private String sacmForThermalComposite;

    /** 封切机贴标 */
    @Excel(name = "封切机贴标")
    private String sacmForLabeling;

    /** 封切机装扣 */
    @Excel(name = "封切机装扣")
    private String sacmForBuckleUp;

    /** 封切机压痕 */
    @Excel(name = "封切机压痕")
    private String sacmForCreasing;

    /** 封切机风琴 */
    @Excel(name = "封切机风琴")
    private String sacmForOrgan;

    /** 封切机热切 */
    @Excel(name = "封切机热切")
    private String sacmForThermalCutting;

    /** 封切机热自合 */
    @Excel(name = "封切机热自合")
    private String sacmForThermalSelfFusion;

    /** 封切机压齿 */
    @Excel(name = "封切机压齿")
    private String sacmForMolarTooth;

    /** 封切机分切 */
    @Excel(name = "封切机分切")
    private String sacmForSlitting;

}
