package com.ximai.mes.md.service.impl;

import java.util.List;
import com.ximai.common.utils.data.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ximai.mes.md.mapper.MdSalesCurrencyMapper;
import com.ximai.mes.md.domain.MdSalesCurrency;
import com.ximai.mes.md.service.IMdSalesCurrencyService;

/**
 * 订单 交易币别Service业务层处理
 *
 * @author yinjinlu
 * @date 2024-01-22
 */
@Service
public class MdSalesCurrencyServiceImpl implements IMdSalesCurrencyService
{
    @Autowired
    private MdSalesCurrencyMapper mdSalesCurrencyMapper;

    /**
     * 查询订单 交易币别
     *
     * @param id 订单 交易币别主键
     * @return 订单 交易币别
     */
    @Override
    public MdSalesCurrency selectMdSalesCurrencyById(String id)
    {
        return mdSalesCurrencyMapper.selectMdSalesCurrencyById(id);
    }

    /**
     * 查询订单 交易币别列表
     *
     * @param mdSalesCurrency 订单 交易币别
     * @return 订单 交易币别
     */
    @Override
    public List<MdSalesCurrency> selectMdSalesCurrencyList(MdSalesCurrency mdSalesCurrency)
    {
        return mdSalesCurrencyMapper.selectMdSalesCurrencyList(mdSalesCurrency);
    }

    /**
     * 新增订单 交易币别
     *
     * @param mdSalesCurrency 订单 交易币别
     * @return 结果
     */
    @Override
    public int insertMdSalesCurrency(MdSalesCurrency mdSalesCurrency)
    {
        mdSalesCurrency.setCreateTime(DateUtils.getNowDate());
        return mdSalesCurrencyMapper.insertMdSalesCurrency(mdSalesCurrency);
    }

    /**
     * 修改订单 交易币别
     *
     * @param mdSalesCurrency 订单 交易币别
     * @return 结果
     */
    @Override
    public int updateMdSalesCurrency(MdSalesCurrency mdSalesCurrency)
    {
        mdSalesCurrency.setUpdateTime(DateUtils.getNowDate());
        return mdSalesCurrencyMapper.updateMdSalesCurrency(mdSalesCurrency);
    }

    /**
     * 批量删除订单 交易币别
     *
     * @param ids 需要删除的订单 交易币别主键
     * @return 结果
     */
    @Override
    public int deleteMdSalesCurrencyByIds(String[] ids)
    {
        return mdSalesCurrencyMapper.deleteMdSalesCurrencyByIds(ids);
    }

    /**
     * 删除订单 交易币别信息
     *
     * @param id 订单 交易币别主键
     * @return 结果
     */
    @Override
    public int deleteMdSalesCurrencyById(String id)
    {
        return mdSalesCurrencyMapper.deleteMdSalesCurrencyById(id);
    }
}
